/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.brain360.valobj;

import cn.bugstack.openai.executor.model.brain360.valobj.Message;
import cn.bugstack.openai.executor.model.brain360.valobj.Model;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Brain360CompletionRequest {
    private String model = Model.Brain_360GPT_S2_V9.getCode();
    private List<Message> messages;
    private Boolean stream = false;
    private Double temperature;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens = 2048;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="repetition_penalty")
    private Double repetitionPenalty;
    @JsonProperty(value="num_beams")
    private Integer numBeams;
    private String user;

    public static Brain360CompletionRequestBuilder builder() {
        return new Brain360CompletionRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Integer getNumBeams() {
        return this.numBeams;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="top_k")
    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    @JsonProperty(value="repetition_penalty")
    public void setRepetitionPenalty(Double repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    @JsonProperty(value="num_beams")
    public void setNumBeams(Integer numBeams) {
        this.numBeams = numBeams;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Brain360CompletionRequest)) {
            return false;
        }
        Brain360CompletionRequest other = (Brain360CompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Double this$repetitionPenalty = this.getRepetitionPenalty();
        Double other$repetitionPenalty = other.getRepetitionPenalty();
        if (this$repetitionPenalty == null ? other$repetitionPenalty != null : !((Object)this$repetitionPenalty).equals(other$repetitionPenalty)) {
            return false;
        }
        Integer this$numBeams = this.getNumBeams();
        Integer other$numBeams = other.getNumBeams();
        if (this$numBeams == null ? other$numBeams != null : !((Object)this$numBeams).equals(other$numBeams)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Brain360CompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Double $repetitionPenalty = this.getRepetitionPenalty();
        result = result * 59 + ($repetitionPenalty == null ? 43 : ((Object)$repetitionPenalty).hashCode());
        Integer $numBeams = this.getNumBeams();
        result = result * 59 + ($numBeams == null ? 43 : ((Object)$numBeams).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "Brain360CompletionRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", stream=" + this.getStream() + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", repetitionPenalty=" + this.getRepetitionPenalty() + ", numBeams=" + this.getNumBeams() + ", user=" + this.getUser() + ")";
    }

    public Brain360CompletionRequest() {
    }

    public Brain360CompletionRequest(String model, List<Message> messages, Boolean stream, Double temperature, Integer maxTokens, Double topP, Integer topK, Double repetitionPenalty, Integer numBeams, String user) {
        this.model = model;
        this.messages = messages;
        this.stream = stream;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.topP = topP;
        this.topK = topK;
        this.repetitionPenalty = repetitionPenalty;
        this.numBeams = numBeams;
        this.user = user;
    }

    public static class Brain360CompletionRequestBuilder {
        private String model;
        private List<Message> messages;
        private Boolean stream;
        private Double temperature;
        private Integer maxTokens;
        private Double topP;
        private Integer topK;
        private Double repetitionPenalty;
        private Integer numBeams;
        private String user;

        Brain360CompletionRequestBuilder() {
        }

        public Brain360CompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public Brain360CompletionRequestBuilder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Brain360CompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Brain360CompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public Brain360CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="top_p")
        public Brain360CompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="top_k")
        public Brain360CompletionRequestBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @JsonProperty(value="repetition_penalty")
        public Brain360CompletionRequestBuilder repetitionPenalty(Double repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        @JsonProperty(value="num_beams")
        public Brain360CompletionRequestBuilder numBeams(Integer numBeams) {
            this.numBeams = numBeams;
            return this;
        }

        public Brain360CompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Brain360CompletionRequest build() {
            return new Brain360CompletionRequest(this.model, this.messages, this.stream, this.temperature, this.maxTokens, this.topP, this.topK, this.repetitionPenalty, this.numBeams, this.user);
        }

        public String toString() {
            return "Brain360CompletionRequest.Brain360CompletionRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", stream=" + this.stream + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", topP=" + this.topP + ", topK=" + this.topK + ", repetitionPenalty=" + this.repetitionPenalty + ", numBeams=" + this.numBeams + ", user=" + this.user + ")";
        }
    }
}

