/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.chatglm;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.chatglm.config.ChatGLMConfig;
import cn.bugstack.openai.executor.model.chatglm.utils.BearerTokenUtils;
import cn.bugstack.openai.executor.model.chatglm.valobj.ChatGLMCompletionRequest;
import cn.bugstack.openai.executor.model.chatglm.valobj.ChatGLMCompletionResponse;
import cn.bugstack.openai.executor.model.chatglm.valobj.EventType;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.parameter.PictureRequest;
import cn.bugstack.openai.executor.parameter.Usage;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGLMModelExecutor
implements Executor,
ParameterHandler<ChatGLMCompletionRequest>,
ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(ChatGLMModelExecutor.class);
    private final ChatGLMConfig chatGLMConfig;
    private final EventSource.Factory factory;

    public ChatGLMModelExecutor(Configuration configuration) {
        this.chatGLMConfig = configuration.getChatGLMConfig();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        ChatGLMCompletionRequest chatGLMCompletionRequest = this.getParameterObject(completionRequest);
        Request request = new Request.Builder().header("Authorization", "Bearer " + BearerTokenUtils.getToken(this.chatGLMConfig.getApiKey(), this.chatGLMConfig.getApiSecret())).url(this.chatGLMConfig.getApiHost().concat(this.chatGLMConfig.getV3_completions()).replace("{model}", completionRequest.getModel())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatGLMCompletionRequest.toString())).build();
        return this.factory.newEventSource(request, this.eventSourceListener(eventSourceListener));
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        ChatGLMCompletionRequest chatGLMCompletionRequest = this.getParameterObject(completionRequest);
        ChatGLMConfig chatGLMConfigByUser = new ChatGLMConfig();
        chatGLMConfigByUser.setApiHost(apiHostByUser);
        if (null != apiKeyByUser) {
            chatGLMConfigByUser.setApiSecretKey(apiKeyByUser);
        }
        String apiHost = chatGLMConfigByUser.getApiHost() == null ? this.chatGLMConfig.getApiHost() : chatGLMConfigByUser.getApiHost();
        String apiKey = chatGLMConfigByUser.getApiKey() == null ? this.chatGLMConfig.getApiKey() : chatGLMConfigByUser.getApiKey();
        String apiSecret = chatGLMConfigByUser.getApiSecret() == null ? this.chatGLMConfig.getApiSecret() : chatGLMConfigByUser.getApiSecret();
        Request request = new Request.Builder().header("Authorization", "Bearer " + BearerTokenUtils.getToken(apiKey, apiSecret)).url(this.chatGLMConfig.getApiHost().concat(this.chatGLMConfig.getV3_completions()).replace("{model}", completionRequest.getModel())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatGLMCompletionRequest.toString())).build();
        return this.factory.newEventSource(request, this.eventSourceListener(eventSourceListener));
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    @Override
    public EventSource pictureUnderstanding(PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public EventSource pictureUnderstanding(String apiHostByUser, String apiKeyByUser, PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public ChatGLMCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        ChatGLMCompletionRequest chatGLMCompletionRequest = new ChatGLMCompletionRequest();
        chatGLMCompletionRequest.setTemperature(completionRequest.getTemperature());
        chatGLMCompletionRequest.setTopP(completionRequest.getTopP());
        ArrayList<ChatGLMCompletionRequest.Prompt> prompts = new ArrayList<ChatGLMCompletionRequest.Prompt>();
        List<Message> messages = completionRequest.getMessages();
        for (int i = 0; i < messages.size(); ++i) {
            Message message = messages.get(i);
            if (0 == i) {
                prompts.add(ChatGLMCompletionRequest.Prompt.builder().role(message.getRole()).content(message.getContent()).build());
                continue;
            }
            String role = message.getRole();
            if (Objects.equals(role, CompletionRequest.Role.SYSTEM.getCode())) {
                prompts.add(ChatGLMCompletionRequest.Prompt.builder().role(CompletionRequest.Role.SYSTEM.getCode()).content(message.getContent()).build());
                prompts.add(ChatGLMCompletionRequest.Prompt.builder().role(CompletionRequest.Role.USER.getCode()).content("Okay").build());
                continue;
            }
            prompts.add(ChatGLMCompletionRequest.Prompt.builder().role(CompletionRequest.Role.USER.getCode()).content(message.getContent()).build());
            prompts.add(ChatGLMCompletionRequest.Prompt.builder().role(CompletionRequest.Role.USER.getCode()).content("Okay").build());
        }
        chatGLMCompletionRequest.setPrompt(prompts);
        return chatGLMCompletionRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(final EventSourceListener eventSourceListener) {
        return new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                ChatGLMCompletionResponse response = (ChatGLMCompletionResponse)JSON.parseObject((String)data, ChatGLMCompletionResponse.class);
                if (EventType.add.getCode().equals(type)) {
                    CompletionResponse completionResponse = new CompletionResponse();
                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setDelta(Message.builder().name("").role(CompletionRequest.Role.SYSTEM).content(response.getData()).build());
                    choices.add(chatChoice);
                    completionResponse.setChoices(choices);
                    eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)completionResponse));
                } else if (EventType.finish.getCode().equals(type)) {
                    ChatGLMCompletionResponse.Meta meta = (ChatGLMCompletionResponse.Meta)JSON.parseObject((String)response.getMeta(), ChatGLMCompletionResponse.Meta.class);
                    ChatGLMCompletionResponse.Usage chatGLMUsage = meta.getUsage();
                    Usage usage = new Usage();
                    usage.setPromptTokens(chatGLMUsage.getPrompt_tokens());
                    usage.setCompletionTokens(chatGLMUsage.getCompletion_tokens());
                    usage.setTotalTokens(chatGLMUsage.getTotal_tokens());
                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setFinishReason("stop");
                    chatChoice.setDelta(Message.builder().name("").role(CompletionRequest.Role.SYSTEM).content(response.getData()).build());
                    choices.add(chatChoice);
                    CompletionResponse completionResponse = new CompletionResponse();
                    completionResponse.setChoices(choices);
                    completionResponse.setUsage(usage);
                    completionResponse.setCreated(System.currentTimeMillis());
                    eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)completionResponse));
                } else {
                    this.onClosed(eventSource);
                }
            }

            public void onClosed(EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }

            public void onOpen(EventSource eventSource, Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }
        };
    }
}

