/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.gemini;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.gemini.config.GeminiProConfig;
import cn.bugstack.openai.executor.model.gemini.valobj.Candidate;
import cn.bugstack.openai.executor.model.gemini.valobj.Content;
import cn.bugstack.openai.executor.model.gemini.valobj.GeminiProCompletionRequest;
import cn.bugstack.openai.executor.model.gemini.valobj.GeminiProCompletionResponse;
import cn.bugstack.openai.executor.model.gemini.valobj.GenerationConfig;
import cn.bugstack.openai.executor.model.gemini.valobj.InlineData;
import cn.bugstack.openai.executor.model.gemini.valobj.Model;
import cn.bugstack.openai.executor.model.gemini.valobj.Parts;
import cn.bugstack.openai.executor.model.gemini.valobj.Role;
import cn.bugstack.openai.executor.model.gemini.valobj.SafetySetting;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.parameter.PictureContentEnum;
import cn.bugstack.openai.executor.parameter.PictureRequest;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okio.BufferedSource;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiProModelExecutor
implements Executor,
ParameterHandler<GeminiProCompletionRequest>,
ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(GeminiProModelExecutor.class);
    private final GeminiProConfig geminiProConfig;
    private final OkHttpClient okHttpClient;

    public GeminiProModelExecutor(Configuration configuration) {
        this.geminiProConfig = configuration.getGeminiProConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        if (!completionRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        String apiHost = null == apiHostByUser ? this.geminiProConfig.getApiHost() : apiHostByUser;
        String apiKey = null == apiKeyByUser ? this.geminiProConfig.getApiKey() : apiKeyByUser;
        GeminiProCompletionRequest geminiProCompletionRequest = this.getParameterObject(completionRequest);
        final Request request = new Request.Builder().addHeader("Content-Type", "application/json").url(apiHost.concat(this.geminiProConfig.getV1beta_chat_completions()).concat(Model.valueOf(completionRequest.getModel().toUpperCase()).getPath()).concat("?key=" + apiKey)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)geminiProCompletionRequest))).build();
        EventSource eventSource = new EventSource(){

            @NotNull
            public Request request() {
                return request;
            }

            public void cancel() {
                log.info("\u8bf7\u6c42\u53d6\u6d88");
            }
        };
        this.excuteRequest(this.okHttpClient, request, eventSource, eventSourceListener);
        return eventSource;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) throws Exception {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) throws Exception {
        return null;
    }

    @Override
    public EventSource pictureUnderstanding(PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.pictureUnderstanding(null, null, pictureRequest, eventSourceListener);
    }

    @Override
    public EventSource pictureUnderstanding(String apiHostByUser, String apiKeyByUser, PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        if (!pictureRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        if (!pictureRequest.getModel().equals(Model.GEMINI_PRO_VERSION.getCode())) {
            throw new RuntimeException("Model is error");
        }
        String apiHost = null == apiHostByUser ? this.geminiProConfig.getApiHost() : apiHostByUser;
        String apiKey = null == apiKeyByUser ? this.geminiProConfig.getApiKey() : apiKeyByUser;
        GeminiProCompletionRequest geminiProCompletionRequest = this.getParameterObject(pictureRequest);
        final Request request = new Request.Builder().addHeader("Content-Type", "application/json").url(apiHost.concat(this.geminiProConfig.getV1beta_chat_completions()).concat(Model.valueOf(pictureRequest.getModel().toUpperCase()).getPath()).concat("?key=" + apiKey)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)geminiProCompletionRequest))).build();
        EventSource eventSource = new EventSource(){

            @NotNull
            public Request request() {
                return request;
            }

            public void cancel() {
                log.info("\u8bf7\u6c42\u53d6\u6d88");
            }
        };
        this.excuteRequest(this.okHttpClient, request, eventSource, eventSourceListener);
        return eventSource;
    }

    @Override
    public GeminiProCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        GeminiProCompletionRequest geminiProCompletionRequest = new GeminiProCompletionRequest();
        ArrayList<Content> contents = new ArrayList<Content>();
        List<Message> messages = completionRequest.getMessages();
        for (Message message : messages) {
            String role = message.getRole().equals(CompletionRequest.Role.USER.getCode()) ? Role.user.getCode() : Role.model.getCode();
            List<Parts> parts = Collections.singletonList(Parts.builder().text(message.getContent()).build());
            Content content = Content.builder().role(role).parts(parts).build();
            contents.add(content);
        }
        GenerationConfig generationConfig = GenerationConfig.builder().temperature(completionRequest.getTemperature()).topP(completionRequest.getTopP()).maxOutputTokens(completionRequest.getMaxTokens()).stopSequences(completionRequest.getStop()).build();
        geminiProCompletionRequest.setContents(contents);
        geminiProCompletionRequest.setGenerationConfig(generationConfig);
        geminiProCompletionRequest.setSafetySettings(Collections.singletonList(new SafetySetting()));
        return geminiProCompletionRequest;
    }

    public GeminiProCompletionRequest getParameterObject(PictureRequest pictureRequest) {
        GeminiProCompletionRequest geminiProCompletionRequest = new GeminiProCompletionRequest();
        ArrayList<Content> contents = new ArrayList<Content>();
        List<PictureRequest.Text> messages = pictureRequest.getMessages();
        ArrayList<Parts> parts = new ArrayList<Parts>();
        for (PictureRequest.Text message : messages) {
            if (message.getContentType().equals(PictureContentEnum.ContentType.TEXT.getValue())) {
                parts.add(Parts.builder().text(message.getContent()).build());
            }
            if (!message.getContentType().equals(PictureContentEnum.ContentType.IMAGE.getValue())) continue;
            parts.add(Parts.builder().inlineData(InlineData.builder().imgData(message.getContent()).build()).build());
        }
        Content content = Content.builder().role(Role.user.getCode()).parts(parts).build();
        contents.add(content);
        GenerationConfig generationConfig = GenerationConfig.builder().temperature(pictureRequest.getTemperature()).maxOutputTokens(pictureRequest.getMaxTokens()).stopSequences(pictureRequest.getStop()).build();
        geminiProCompletionRequest.setContents(contents);
        geminiProCompletionRequest.setGenerationConfig(generationConfig);
        geminiProCompletionRequest.setSafetySettings(Collections.singletonList(new SafetySetting()));
        return geminiProCompletionRequest;
    }

    private void excuteRequest(OkHttpClient okHttpClient, Request request, final EventSource eventSource, final EventSourceListener eventSourceListener) {
        okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        try (BufferedSource source = responseBody.source();){
                            try {
                                while (!source.exhausted()) {
                                    String data = source.readUtf8();
                                    CompletionResponse completionResponse = new CompletionResponse();
                                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                                    List geminiCompletionResponses = JSON.parseArray((String)data, GeminiProCompletionResponse.class);
                                    for (GeminiProCompletionResponse geminiCompletionResponse : geminiCompletionResponses) {
                                        Candidate candidate = geminiCompletionResponse.getCandidates().get(0);
                                        Content content = candidate.getContent();
                                        if (!ObjectUtils.isNotEmpty((Object)content)) continue;
                                        String finishReason = candidate.getFinishReason();
                                        ChatChoice chatChoice = new ChatChoice();
                                        chatChoice.setDelta(Message.builder().name("").role(CompletionRequest.Role.MODEL).content(content.getParts().get(0).getText()).build());
                                        chatChoice.setFinishReason(finishReason);
                                        choices.add(chatChoice);
                                    }
                                    completionResponse.setChoices(choices);
                                    eventSourceListener.onEvent(eventSource, null, null, JSON.toJSONString((Object)completionResponse));
                                }
                            }
                            finally {
                                source.close();
                                eventSourceListener.onClosed(eventSource);
                            }
                        }
                    }
                } else {
                    System.out.println("Request failed. Response code: " + response.code());
                }
            }
        });
    }
}

