/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google;

import cn.bugstack.openai.executor.model.google.GeminiProModelExecutor;
import cn.bugstack.openai.executor.model.google.config.Const;
import cn.bugstack.openai.executor.model.google.valobj.GeminiProRole;
import cn.bugstack.openai.executor.model.google.valobj.model.GeminiProModel;
import cn.bugstack.openai.executor.model.google.valobj.model.Model;
import cn.bugstack.openai.executor.model.google.valobj.request.GeminiProTextRequest;
import cn.bugstack.openai.executor.model.google.valobj.request.TextPrompt;
import cn.bugstack.openai.executor.model.google.valobj.response.GeminiProCompletionResponse;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiProTextModelExecutor
extends GeminiProModelExecutor {
    private static final Logger log = LoggerFactory.getLogger(GeminiProTextModelExecutor.class);

    public GeminiProTextModelExecutor(Configuration configuration) {
        super(configuration);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        if (completionRequest.isStream() && CompletionRequest.Model.TEXT_GEMINI_PRO.getCode().equals(completionRequest.getModel())) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        GeminiProTextRequest textRequest = this.getParameterObject(completionRequest);
        String apiHost = apiHostByUser == null ? this.getGeminiProConfig().getApiHost() : apiHostByUser;
        String apiKey = apiKeyByUser == null ? this.getGeminiProConfig().getApiKey() : apiKeyByUser;
        Model model = GeminiProModel.getModel(completionRequest.getModel());
        final Request request = new Request.Builder().addHeader("Content-Type", "application/json").url(String.format("%s%s%s:%s?key=%s", apiHost, Const.V1_BATA_GEMINI_PRO_COMPLETIONS, model.getName(), model.getSupportMethod().getGenerateMethod(), apiKey)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)textRequest))).build();
        final Call call = this.getOkHttpClient().newCall(request);
        EventSource eventSource = new EventSource(){

            public Request request() {
                return request;
            }

            public void cancel() {
                call.cancel();
            }
        };
        call.enqueue((Callback)new ResponseCallBack(eventSourceListener, eventSource));
        return eventSource;
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    @Override
    public GeminiProTextRequest getParameterObject(CompletionRequest completionRequest) {
        List<Message> messages = completionRequest.getMessages();
        GeminiProTextRequest textRequest = new GeminiProTextRequest();
        if (messages == null || messages.isEmpty()) {
            return textRequest;
        }
        List<GeminiProTextRequest.Content> contents = messages.stream().map(it -> {
            String role = null;
            if (CompletionRequest.Role.SYSTEM.getCode().equals(it.getRole())) {
                role = GeminiProRole.SYSTEM.getCode();
            } else if (CompletionRequest.Role.USER.getCode().equals(it.getRole())) {
                role = GeminiProRole.USER.getCode();
            }
            GeminiProTextRequest.Content content = GeminiProTextRequest.Content.builder().role(role).parts(Lists.newArrayList((Object[])new TextPrompt[]{new TextPrompt(it.getContent())})).build();
            return content;
        }).collect(Collectors.toList());
        textRequest.setContents(contents);
        GeminiProTextRequest.GenerationConfig generationConfig = new GeminiProTextRequest.GenerationConfig();
        generationConfig.setTemperature(completionRequest.getTemperature());
        generationConfig.setTopP(completionRequest.getTopP());
        generationConfig.setStopSequences(completionRequest.getStop());
        generationConfig.setMaxOutputTokens(completionRequest.getMaxTokens());
        textRequest.setGenerationConfig(generationConfig);
        return textRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }

    private static class ResponseCallBack
    implements Callback {
        private final EventSourceListener eventSourceListener;
        private final EventSource eventSource;

        public ResponseCallBack(EventSourceListener eventSourceListener, EventSource eventSource) {
            this.eventSourceListener = eventSourceListener;
            this.eventSource = eventSource;
        }

        public void onFailure(Call call, IOException e) {
            call.cancel();
        }

        public void onResponse(Call call, Response response) throws IOException {
            CompletionResponse completionResponse = new CompletionResponse();
            ResponseBody body = response.body();
            ArrayList<ChatChoice> chatChoices = new ArrayList<ChatChoice>();
            completionResponse.setChoices(chatChoices);
            if (response.isSuccessful() && body != null) {
                List geminiProCompletionResponse = JSON.parseArray((String)body.string(), GeminiProCompletionResponse.class);
                geminiProCompletionResponse.stream().map(GeminiProCompletionResponse::getCandidates).forEach(it -> {
                    String msg = ((GeminiProCompletionResponse.Candidate)it.get(0)).getContent().getParts().stream().map(GeminiProCompletionResponse.Part::getText).collect(Collectors.joining());
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setDelta(Message.builder().role(CompletionRequest.Role.SYSTEM).name(completionResponse.getModel()).content(msg).build());
                    chatChoices.add(chatChoice);
                });
                completionResponse.setChoices(chatChoices);
            }
            ChatChoice chatChoice = new ChatChoice();
            chatChoice.setFinishReason("stop");
            chatChoice.setDelta(new Message());
            chatChoices.add(chatChoice);
            this.eventSourceListener.onEvent(this.eventSource, null, null, JSON.toJSONString((Object)completionResponse));
        }
    }
}

