/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google.valobj.request;

import cn.bugstack.openai.executor.model.google.valobj.request.TextPrompt;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GeminiProTextRequest {
    private static final Logger log = LoggerFactory.getLogger(GeminiProTextRequest.class);
    private List<SafetySetting> safetySettings;
    private List<Content> contents;
    private GenerationConfig generationConfig;

    public void setMessage(String message, String user) {
        TextPrompt textPrompt = new TextPrompt();
        textPrompt.setText(message);
        Content content = Content.builder().role(user).parts(Lists.newArrayList((Object[])new TextPrompt[]{textPrompt})).build();
        this.contents = Lists.newArrayList((Object[])new Content[]{content});
    }

    public static GeminiProTextRequestBuilder builder() {
        return new GeminiProTextRequestBuilder();
    }

    public List<SafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public void setSafetySettings(List<SafetySetting> safetySettings) {
        this.safetySettings = safetySettings;
    }

    public void setContents(List<Content> contents) {
        this.contents = contents;
    }

    public void setGenerationConfig(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiProTextRequest)) {
            return false;
        }
        GeminiProTextRequest other = (GeminiProTextRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SafetySetting> this$safetySettings = this.getSafetySettings();
        List<SafetySetting> other$safetySettings = other.getSafetySettings();
        if (this$safetySettings == null ? other$safetySettings != null : !((Object)this$safetySettings).equals(other$safetySettings)) {
            return false;
        }
        List<Content> this$contents = this.getContents();
        List<Content> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        GenerationConfig this$generationConfig = this.getGenerationConfig();
        GenerationConfig other$generationConfig = other.getGenerationConfig();
        return !(this$generationConfig == null ? other$generationConfig != null : !((Object)this$generationConfig).equals(other$generationConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiProTextRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SafetySetting> $safetySettings = this.getSafetySettings();
        result = result * 59 + ($safetySettings == null ? 43 : ((Object)$safetySettings).hashCode());
        List<Content> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        GenerationConfig $generationConfig = this.getGenerationConfig();
        result = result * 59 + ($generationConfig == null ? 43 : ((Object)$generationConfig).hashCode());
        return result;
    }

    public String toString() {
        return "GeminiProTextRequest(safetySettings=" + this.getSafetySettings() + ", contents=" + this.getContents() + ", generationConfig=" + this.getGenerationConfig() + ")";
    }

    public GeminiProTextRequest() {
    }

    public GeminiProTextRequest(List<SafetySetting> safetySettings, List<Content> contents, GenerationConfig generationConfig) {
        this.safetySettings = safetySettings;
        this.contents = contents;
        this.generationConfig = generationConfig;
    }

    public static class GeminiProTextRequestBuilder {
        private List<SafetySetting> safetySettings;
        private List<Content> contents;
        private GenerationConfig generationConfig;

        GeminiProTextRequestBuilder() {
        }

        public GeminiProTextRequestBuilder safetySettings(List<SafetySetting> safetySettings) {
            this.safetySettings = safetySettings;
            return this;
        }

        public GeminiProTextRequestBuilder contents(List<Content> contents) {
            this.contents = contents;
            return this;
        }

        public GeminiProTextRequestBuilder generationConfig(GenerationConfig generationConfig) {
            this.generationConfig = generationConfig;
            return this;
        }

        public GeminiProTextRequest build() {
            return new GeminiProTextRequest(this.safetySettings, this.contents, this.generationConfig);
        }

        public String toString() {
            return "GeminiProTextRequest.GeminiProTextRequestBuilder(safetySettings=" + this.safetySettings + ", contents=" + this.contents + ", generationConfig=" + this.generationConfig + ")";
        }
    }

    public static class SafetySetting {
        private String threshold;
        private String category;

        public String getThreshold() {
            return this.threshold;
        }

        public String getCategory() {
            return this.category;
        }

        public void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SafetySetting)) {
                return false;
            }
            SafetySetting other = (SafetySetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$threshold = this.getThreshold();
            String other$threshold = other.getThreshold();
            if (this$threshold == null ? other$threshold != null : !this$threshold.equals(other$threshold)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            return !(this$category == null ? other$category != null : !this$category.equals(other$category));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SafetySetting;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $threshold = this.getThreshold();
            result = result * 59 + ($threshold == null ? 43 : $threshold.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            return result;
        }

        public String toString() {
            return "GeminiProTextRequest.SafetySetting(threshold=" + this.getThreshold() + ", category=" + this.getCategory() + ")";
        }
    }

    public static class GenerationConfig {
        private List<String> stopSequences;
        private Double temperature = 1.0;
        private Integer maxOutputTokens = 800;
        private Double topP = 0.8;
        private Integer topK = 10;

        public List<String> getStopSequences() {
            return this.stopSequences;
        }

        public Double getTemperature() {
            return this.temperature;
        }

        public Integer getMaxOutputTokens() {
            return this.maxOutputTokens;
        }

        public Double getTopP() {
            return this.topP;
        }

        public Integer getTopK() {
            return this.topK;
        }

        public void setStopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
        }

        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        public void setMaxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
        }

        public void setTopP(Double topP) {
            this.topP = topP;
        }

        public void setTopK(Integer topK) {
            this.topK = topK;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenerationConfig)) {
                return false;
            }
            GenerationConfig other = (GenerationConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$temperature = this.getTemperature();
            Double other$temperature = other.getTemperature();
            if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
                return false;
            }
            Integer this$maxOutputTokens = this.getMaxOutputTokens();
            Integer other$maxOutputTokens = other.getMaxOutputTokens();
            if (this$maxOutputTokens == null ? other$maxOutputTokens != null : !((Object)this$maxOutputTokens).equals(other$maxOutputTokens)) {
                return false;
            }
            Double this$topP = this.getTopP();
            Double other$topP = other.getTopP();
            if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
                return false;
            }
            Integer this$topK = this.getTopK();
            Integer other$topK = other.getTopK();
            if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
                return false;
            }
            List<String> this$stopSequences = this.getStopSequences();
            List<String> other$stopSequences = other.getStopSequences();
            return !(this$stopSequences == null ? other$stopSequences != null : !((Object)this$stopSequences).equals(other$stopSequences));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenerationConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $temperature = this.getTemperature();
            result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
            Integer $maxOutputTokens = this.getMaxOutputTokens();
            result = result * 59 + ($maxOutputTokens == null ? 43 : ((Object)$maxOutputTokens).hashCode());
            Double $topP = this.getTopP();
            result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
            Integer $topK = this.getTopK();
            result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
            List<String> $stopSequences = this.getStopSequences();
            result = result * 59 + ($stopSequences == null ? 43 : ((Object)$stopSequences).hashCode());
            return result;
        }

        public String toString() {
            return "GeminiProTextRequest.GenerationConfig(stopSequences=" + this.getStopSequences() + ", temperature=" + this.getTemperature() + ", maxOutputTokens=" + this.getMaxOutputTokens() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ")";
        }
    }

    public static class Content {
        private String role;
        private List<TextPrompt> parts;

        public static ContentBuilder builder() {
            return new ContentBuilder();
        }

        public Content() {
        }

        public Content(String role, List<TextPrompt> parts) {
            this.role = role;
            this.parts = parts;
        }

        public String getRole() {
            return this.role;
        }

        public List<TextPrompt> getParts() {
            return this.parts;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setParts(List<TextPrompt> parts) {
            this.parts = parts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            List<TextPrompt> this$parts = this.getParts();
            List<TextPrompt> other$parts = other.getParts();
            return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            List<TextPrompt> $parts = this.getParts();
            result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
            return result;
        }

        public String toString() {
            return "GeminiProTextRequest.Content(role=" + this.getRole() + ", parts=" + this.getParts() + ")";
        }

        public static class ContentBuilder {
            private String role;
            private List<TextPrompt> parts;

            ContentBuilder() {
            }

            public ContentBuilder role(String role) {
                this.role = role;
                return this;
            }

            public ContentBuilder parts(List<TextPrompt> parts) {
                this.parts = parts;
                return this;
            }

            public Content build() {
                return new Content(this.role, this.parts);
            }

            public String toString() {
                return "GeminiProTextRequest.Content.ContentBuilder(role=" + this.role + ", parts=" + this.parts + ")";
            }
        }
    }
}

