/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.tencent;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.tencent.config.TencentConfig;
import cn.bugstack.openai.executor.model.tencent.utils.SecurityUtils;
import cn.bugstack.openai.executor.model.tencent.valobj.Action;
import cn.bugstack.openai.executor.model.tencent.valobj.Message;
import cn.bugstack.openai.executor.model.tencent.valobj.TencentCompletionRequest;
import cn.bugstack.openai.executor.model.tencent.valobj.TencentCompletionResponse;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.parameter.PictureRequest;
import cn.bugstack.openai.executor.parameter.Usage;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class TencentModelExecutor
implements Executor,
ParameterHandler<TencentCompletionRequest>,
ResultHandler {
    private static final String FINISH_REASON_STOP = "stop";
    private final EventSource.Factory factory;
    private final TencentConfig tencentConfig;

    public TencentModelExecutor(Configuration configuration) {
        this.tencentConfig = configuration.getTencentConfig();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        TencentCompletionRequest tencentCompletionRequest = this.getParameterObject(completionRequest);
        String action = Action.of(completionRequest.getModel());
        String version = this.tencentConfig.getApiVersion();
        String region = this.tencentConfig.getRegion();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String requestPayload = JSON.toJSONString((Object)tencentCompletionRequest);
        String authorization = SecurityUtils.getAuthorization(requestPayload, timestamp, this.tencentConfig);
        Request request = new Request.Builder().header("Authorization", authorization).header("X-TC-Action", action).header("X-TC-Timestamp", timestamp).header("X-TC-Version", version).header("X-TC-Region", region).header("Accept", "text/event-stream").url(this.tencentConfig.getApiHost()).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestPayload)).build();
        return this.factory.newEventSource(request, this.eventSourceListener(eventSourceListener));
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        throw new NotImplementedException("\u6ca1\u6709\u5b9e\u73b0\u6b64\u65b9\u6cd5");
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    @Override
    public EventSource pictureUnderstanding(PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public EventSource pictureUnderstanding(String apiHostByUser, String apiKeyByUser, PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public TencentCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        List<Message> messages = completionRequest.getMessages().stream().map(Message::of).collect(Collectors.toList());
        return TencentCompletionRequest.builder().messages(messages).temperature(completionRequest.getTemperature()).topP(completionRequest.getTopP()).build();
    }

    @Override
    public EventSourceListener eventSourceListener(final EventSourceListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(EventSource eventSource, Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                TencentCompletionResponse response = (TencentCompletionResponse)JSON.parseObject((String)data, TencentCompletionResponse.class);
                TencentCompletionResponse.Choice choice = response.getChoices().get(0);
                boolean stopped = TencentModelExecutor.FINISH_REASON_STOP.equals(choice.getFinishReason());
                if (stopped) {
                    TencentCompletionResponse.Usage tencentUsage = response.getUsage();
                    Usage usage = new Usage();
                    usage.setPromptTokens(tencentUsage.getPromptTokens());
                    usage.setCompletionTokens(tencentUsage.getCompletionTokens());
                    usage.setTotalTokens(tencentUsage.getTotalTokens());
                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setFinishReason(TencentModelExecutor.FINISH_REASON_STOP);
                    String content = choice.getDelta().getContent();
                    chatChoice.setDelta(cn.bugstack.openai.executor.parameter.Message.builder().name("").role(CompletionRequest.Role.SYSTEM).content(content).build());
                    choices.add(chatChoice);
                    CompletionResponse completionResponse = new CompletionResponse();
                    completionResponse.setChoices(choices);
                    completionResponse.setUsage(usage);
                    completionResponse.setCreated(System.currentTimeMillis());
                    eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)completionResponse));
                } else {
                    CompletionResponse completionResponse = new CompletionResponse();
                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                    ChatChoice chatChoice = new ChatChoice();
                    String content = choice.getDelta().getContent();
                    chatChoice.setDelta(cn.bugstack.openai.executor.parameter.Message.builder().name("").role(CompletionRequest.Role.SYSTEM).content(content).build());
                    choices.add(chatChoice);
                    completionResponse.setChoices(choices);
                    completionResponse.setCreated(System.currentTimeMillis());
                    eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)completionResponse));
                }
            }

            public void onClosed(EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }
        };
    }
}

