/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.parameter;

import cn.bugstack.openai.executor.parameter.PictureContentEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PictureRequest
extends PictureContentEnum {
    private static final Logger log = LoggerFactory.getLogger(PictureRequest.class);
    private String model;
    private List<Text> messages;
    private double temperature;
    private boolean stream;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;

    private static double $default$temperature() {
        return 0.5;
    }

    private static boolean $default$stream() {
        return false;
    }

    private static Integer $default$maxTokens() {
        return 2048;
    }

    public static PictureRequestBuilder builder() {
        return new PictureRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<Text> getMessages() {
        return this.messages;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public PictureRequest() {
        this.temperature = PictureRequest.$default$temperature();
        this.stream = PictureRequest.$default$stream();
        this.maxTokens = PictureRequest.$default$maxTokens();
    }

    public PictureRequest(String model, List<Text> messages, double temperature, boolean stream, List<String> stop, Integer maxTokens) {
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
    }

    public static class PictureRequestBuilder {
        private String model;
        private List<Text> messages;
        private boolean temperature$set;
        private double temperature$value;
        private boolean stream$set;
        private boolean stream$value;
        private List<String> stop;
        private boolean maxTokens$set;
        private Integer maxTokens$value;

        PictureRequestBuilder() {
        }

        public PictureRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public PictureRequestBuilder messages(List<Text> messages) {
            this.messages = messages;
            return this;
        }

        public PictureRequestBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        public PictureRequestBuilder stream(boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        public PictureRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public PictureRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this;
        }

        public PictureRequest build() {
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = PictureRequest.$default$temperature();
            }
            boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = PictureRequest.$default$stream();
            }
            Integer maxTokens$value = this.maxTokens$value;
            if (!this.maxTokens$set) {
                maxTokens$value = PictureRequest.$default$maxTokens();
            }
            return new PictureRequest(this.model, this.messages, temperature$value, stream$value, this.stop, maxTokens$value);
        }

        public String toString() {
            return "PictureRequest.PictureRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", temperature$value=" + this.temperature$value + ", stream$value=" + this.stream$value + ", stop=" + this.stop + ", maxTokens$value=" + this.maxTokens$value + ")";
        }
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant");

        private final String code;

        public String getCode() {
            return this.code;
        }

        private Role(String code) {
            this.code = code;
        }
    }

    public static class Text {
        private Role role;
        private String content;
        private String contentType;

        public static TextBuilder builder() {
            return new TextBuilder();
        }

        public Role getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setRole(Role role) {
            this.role = role;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Text)) {
                return false;
            }
            Text other = (Text)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Text;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            return result;
        }

        public String toString() {
            return "PictureRequest.Text(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ", contentType=" + this.getContentType() + ")";
        }

        public Text(Role role, String content, String contentType) {
            this.role = role;
            this.content = content;
            this.contentType = contentType;
        }

        public static class TextBuilder {
            private Role role;
            private String content;
            private String contentType;

            TextBuilder() {
            }

            public TextBuilder role(Role role) {
                this.role = role;
                return this;
            }

            public TextBuilder content(String content) {
                this.content = content;
                return this;
            }

            public TextBuilder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Text build() {
                return new Text(this.role, this.content, this.contentType);
            }

            public String toString() {
                return "PictureRequest.Text.TextBuilder(role=" + (Object)((Object)this.role) + ", content=" + this.content + ", contentType=" + this.contentType + ")";
            }
        }
    }
}

