/*
 * Decompiled with CFR 0.152.
 */
package nbcp.http.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nbcp.base.comm.JsonMap;
import nbcp.base.comm.MyJsonUtil;
import nbcp.base.comm.StringMap;
import nbcp.base.extend.StringHelper;
import nbcp.base.utils.JavaKotlinUtil;
import nbcp.http.HttpClient;
import nbcp.http.annotation.Delete;
import nbcp.http.annotation.Get;
import nbcp.http.annotation.NonThrow;
import nbcp.http.annotation.PathVariable;
import nbcp.http.annotation.Post;
import nbcp.http.annotation.RequestBody;
import nbcp.http.annotation.RequestParam;

@HttpClient(value="docker-client")
public interface DockerClientApi {
    default public List<DockerContainer> containers() {
        return this.containers(null, null, null);
    }

    default public List<DockerContainer> containers(@RequestParam String containerName, @RequestParam String imageNameVersion, @RequestParam DockerContainerStatusEnum[] status) {
        JsonMap map = new JsonMap();
        if (StringHelper.hasValue((String)containerName)) {
            map.put((Object)"name", (Object)JavaKotlinUtil.listOf((Object[])new String[]{containerName}));
        }
        if (StringHelper.hasValue((String)imageNameVersion)) {
            map.put((Object)"ancestor", (Object)JavaKotlinUtil.listOf((Object[])new String[]{imageNameVersion}));
        }
        if (status != null && status.length > 0) {
            map.put((Object)"status", (Object)status);
        }
        return this.ori_all_containers(null, MyJsonUtil.toJson((Object)map));
    }

    @Get(value="/containers/json")
    public List<DockerContainer> ori_all_containers(@RequestParam Boolean var1, @RequestParam String var2);

    @Post(value="/containers/{id}/kill")
    @NonThrow
    public void killContainer(@PathVariable String var1);

    @Post(value="/containers/{id}/start")
    @NonThrow
    public void startContainer(@PathVariable String var1);

    @Get(value="/containers/{id}/json")
    @NonThrow
    public ContainerJson inspectContainer(@PathVariable String var1);

    @Post(value="/containers/create")
    public IdModel addContainer(@RequestBody ContainerAddModel var1);

    @Delete(value="/containers/{id}")
    @NonThrow
    public void removeContainer(@PathVariable(value="id") String var1, @RequestParam(value="force") Boolean var2);

    default public List<DockerImage> images() {
        return this.images(null);
    }

    default public List<DockerImage> images(@RequestParam String imageName) {
        JsonMap map = new JsonMap();
        if (StringHelper.hasValue((String)imageName)) {
            map.put((Object)"reference", (Object)JavaKotlinUtil.listOf((Object[])new String[]{imageName}));
        }
        return this.ori_all_images(null, MyJsonUtil.toJson((Object)map));
    }

    @Get(value="/images/json")
    public List<DockerImage> ori_all_images(@RequestParam Boolean var1, @RequestParam String var2);

    @Get(value="/images/{name}/json")
    @NonThrow
    public DockerImageDetail imageInfo(@PathVariable(value="name") String var1);

    @Delete(value="/images/{name}")
    @NonThrow
    public List<StringMap> deleteImage(@PathVariable(value="name") String var1);

    public static class DockerImageDetail
    extends DockerImage {
        public String Parent = "";
        public String Comment = "";
        public String Author = "";
        public String DockerVersion = "";
        public String Created = "";
        public DockerImageConfig Config = new DockerImageConfig();
        public DockerImageRootFS RootFS = new DockerImageRootFS();

        public static class DockerImageRootFS {
            public String Type = "";
            public List<String> Layers = new ArrayList<String>();
        }

        public static class DockerImageConfig {
            public List<String> Env = new ArrayList<String>();
            public List<String> Cmd = new ArrayList<String>();
            public String WorkingDir = "";
            public String Entrypoint = "";
        }
    }

    public static class DockerImage {
        public String Id = "";
        public List<String> RepoTags = new ArrayList<String>();
        public Integer Size = 0;
    }

    public static class IdModel {
        public String Id = "";
    }

    public static class ContainerAddModel {
        public List<String> Env = new ArrayList<String>();
        public List<String> Cmd = new ArrayList<String>();
        public String Entrypoint = "";
        public String Image = "";
        public Map<String, Object> Labels = new LinkedHashMap<String, Object>();
        public Map<String, Object> Volumes = new LinkedHashMap<String, Object>();
        public String WorkingDir = "";
        public Map<String, Object> ExposedPorts = new LinkedHashMap<String, Object>();
        public HostConfigModel HostConfig = new HostConfigModel();

        public static class HostConfigModel {
            public List<String> Binds = new ArrayList<String>();
            public List<String> Links = new ArrayList<String>();
            public Integer Memory = 0;
            public Integer NanoCpus = 0;
            public Integer CpuShares = 0;
            public Integer CpuPeriod = 0;
            public Map<String, Object> PortBindings = new LinkedHashMap<String, Object>();
            public Boolean PublishAllPorts = false;
            public Boolean Privileged = false;
            public Boolean ReadonlyRootfs = false;
            public List<String> Dns = new ArrayList<String>();
            public String NetworkMode = "bridge";
            public Integer ShmSize = 0;
        }
    }

    public static class ContainerJson {
        public String Id;
        public String Created;
        public String Path;
        public List<String> Args;
        public StateModel State;
        public String Image;
        public String ResolvConfPath;
        public String HostnamePath;
        public String HostsPath;
        public String LogPath;
        public String Name;
        public Integer RestartCount;
        public String Driver;
        public String Platform;
        public String MountLabel;
        public String ProcessLabel;
        public String AppArmorProfile;
        public HostConfigModel HostConfig;
        public GraphDriverModel GraphDriver;
        public List<MountsModel> Mounts;
        public ConfigModel Config;
        public List<NetworkSettingsModel> NetworkSettings;

        public static class NetworkSettingsModel {
            public String Bridge;
            public String SandboxID;
            public Boolean HairpinMode;
            public String LinkLocalIPv6Address;
            public Integer LinkLocalIPv6PrefixLen;
            public Map Ports;
            public String SandboxKey;
            public Object SecondaryIPAddresses;
            public Object SecondaryIPv6Addresses;
            public String EndpointID;
            public String Gateway;
            public String GlobalIPv6Address;
            public Integer GlobalIPv6PrefixLen;
            public String IPAddress;
            public Integer IPPrefixLen;
            public String IPv6Gateway;
            public String MacAddress;
            public Map<String, NetworkModel> Networks;
        }

        public static class NetworkModel {
            public Object IPAMConfig;
            public Object Links;
            public List<String> Aliases;
            public String NetworkID;
            public String EndpointID;
            public String Gateway;
            public String IPAddress;
            public Integer IPPrefixLen;
            public String IPv6Gateway;
            public String GlobalIPv6Address;
            public Integer GlobalIPv6PrefixLen;
            public String MacAddress;
            public Object DriverOpts;
        }

        public static class ConfigModel {
            public String Hostname;
            public String Domainname;
            public String User;
            public Boolean AttachStdin;
            public Boolean AttachStdout;
            public Boolean AttachStderr;
            public Boolean Tty;
            public Boolean OpenStdin;
            public Boolean StdinOnce;
            public List<String> Env;
            public List<String> Cmd;
            public String Image;
            public Object Volumes;
            public String WorkingDir;
            public Map Labels;
        }

        public static class MountsModel {
            public String Type;
            public String Source;
            public String Destination;
            public String Mode;
            public Boolean RW;
            public String Propagation;
        }

        public static class GraphDriverModel {
            public DataModel Data;
            public String Name;
        }

        public static class DataModel {
            public String LowerDir;
            public String MergedDir;
            public String UpperDir;
            public String WorkDir;
        }

        public static class HostConfigModel {
            public List<String> Binds;
            public String ContainerIDFile;
            public LogConfigModel LogConfig;
            public String NetworkMode;
            public Map PortBindings;
            public RestartPolicyModel RestartPolicy;
            public Boolean AutoRemove;
            public String VolumeDriver;
            public List<Integer> ConsoleSize;
            public String CgroupnsMode;
            public List<String> Dns;
            public List<String> DnsOptions;
            public List<String> DnsSearch;
            public List<String> ExtraHosts;
            public String IpcMode;
            public String Cgroup;
            public Integer OomScoreAdj;
            public String PidMode;
            public Boolean Privileged;
            public Boolean PublishAllPorts;
            public Boolean ReadonlyRootfs;
            public String UTSMode;
            public String UsernsMode;
            public Integer ShmSize;
            public String Runtime;
            public String Isolation;
            public Integer CpuShares;
            public Integer Memory;
            public Integer NanoCpus;
            public String CgroupParent;
            public Integer BlkioWeight;
            public List<String> BlkioWeightDevice;
            public List<String> BlkioDeviceReadBps;
            public List<String> BlkioDeviceWriteBps;
            public List<String> BlkioDeviceReadIOps;
            public List<String> BlkioDeviceWriteIOps;
            public Integer CpuPeriod;
            public Integer CpuQuota;
            public Integer CpuRealtimePeriod;
            public Integer CpuRealtimeRuntime;
            public String CpusetCpus;
            public String CpusetMems;
            public List<String> Devices;
            public Object DeviceCgroupRules;
            public Object DeviceRequests;
            public Integer MemoryReservation;
            public Integer MemorySwap;
            public Object MemorySwappiness;
            public Boolean OomKillDisable;
            public Integer CpuCount;
            public Integer CpuPercent;
            public Integer IOMaximumIOps;
            public Integer IOMaximumBandwidth;
            public List<String> MaskedPaths;
            public List<String> ReadonlyPaths;
        }

        public static class RestartPolicyModel {
            public String Name;
            public Integer MaximumRetryCount;
        }

        public static class LogConfigModel {
            public String Type;
            public Map Config;
        }

        public static class StateModel {
            public String Status;
            public Boolean Running;
            public Boolean Paused;
            public Boolean Restarting;
            public Boolean OOMKilled;
            public Boolean Dead;
            public Integer Pid;
            public Integer ExitCode;
            public String Error;
            public String StartedAt;
            public String FinishedAt;
        }
    }

    public static enum DockerContainerStatusEnum {
        exited,
        dead,
        paused;

    }

    public static class DockerContainer {
        public String Id;
        public List<String> Names;
        public String Image;
        public String ImageID;
        public String Command;
        public Integer Created;
        public String State;
        public String Status;
        public HostConfigModel HostConfig;
        public NetworkSettingsModel NetworkSettings;
        public List<MountsModel> Mounts;

        public String getContainerName() {
            if (this.Names == null || this.Names.isEmpty()) {
                return "";
            }
            return this.Names.get(0).replace("/", "");
        }

        public String getContainerIp() {
            Collection<NetworkSettingModel> values = this.NetworkSettings.Networks.values();
            if (values.isEmpty()) {
                return "";
            }
            return values.stream().findFirst().get().IPAddress;
        }

        public static class MountsModel {
            public String Type;
            public String Source;
            public String Destination;
            public String Mode;
            public Boolean RW;
            public String Propagation;
        }

        public static class NetworkSettingsModel {
            public Map<String, NetworkSettingModel> Networks;
        }

        public static class NetworkSettingModel {
            public String NetworkID;
            public String EndpointID;
            public String Gateway;
            public String IPAddress;
            public Integer IPPrefixLen;
            public String IPv6Gateway;
            public String MacAddress;
        }

        public static class HostConfigModel {
            public String NetworkMode;
        }
    }
}

