/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.commons.rest;

import cn.eppdev.jee.commons.entity.BasicEntity;
import cn.eppdev.jee.commons.entity.RestResult;
import cn.eppdev.jee.commons.param.BasicParam;
import cn.eppdev.jee.commons.service.BasicService;
import cn.eppdev.jee.commons.service.SysService;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class BasicController<T extends BasicEntity, P extends BasicParam> {
    static Logger logger = LoggerFactory.getLogger(BasicController.class);
    @Autowired
    BasicService<T, P> service;
    @Autowired
    SysService sysService;

    @RequestMapping(value={"/get/{id}"})
    public RestResult<T> get(@PathVariable(value="id") String id) {
        RestResult<Object> restResult;
        logger.debug("{}/get/{}", (Object)this.getBasicUrl(), (Object)id);
        try {
            T data = this.service.get(id);
            restResult = null == data ? new RestResult<Object>(2001, "\u6570\u636e\u4e0d\u5b58\u5728", null) : new RestResult<T>(2000, "\u83b7\u53d6\u6210\u529f", data);
        }
        catch (Exception e) {
            restResult = new RestResult<Object>(2001, e.getMessage(), null);
        }
        logger.debug("{}/get/{} -> result: {}", new Object[]{this.getBasicUrl(), id, restResult});
        return restResult;
    }

    @RequestMapping(value={"/add"})
    public RestResult<String> add(@RequestBody T entity) {
        RestResult<Object> restResult = null;
        logger.debug("{}/add -> entity:{}", (Object)this.getBasicUrl(), entity);
        try {
            int cnt;
            String userId = this.sysService.getCurrentUserId();
            if (userId != null) {
                ((BasicEntity)entity).setCreateBy(userId);
                ((BasicEntity)entity).setUpdateBy(userId);
            }
            restResult = (cnt = this.service.insert(entity)) == 1 ? new RestResult<String>(2000, "\u6dfb\u52a0\u6210\u529f", ((BasicEntity)entity).getId()) : new RestResult<Object>(2001, "\u6dfb\u52a0\u5931\u8d25\uff0c\u6570\u636e\u91cd\u590d\uff1f", null);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            restResult = new RestResult<Object>(2001, e.getMessage(), null);
        }
        logger.debug("{}/add -> result:{}", (Object)this.getBasicUrl(), restResult);
        return restResult;
    }

    @RequestMapping(value={"/delete/{id}"})
    public RestResult<Integer> delete(@PathVariable(value="id") String id) {
        logger.debug("{}/delete/{}", (Object)this.getBasicUrl(), (Object)id);
        RestResult<Object> restResult = null;
        try {
            String userId = this.sysService.getCurrentUserId();
            int count = this.service.delete(id, userId);
            restResult = count == 1 ? new RestResult<Integer>(2000, "\u5220\u9664\u6210\u529f", count) : new RestResult<Integer>(2001, "\u5220\u9664\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728\uff1f", count);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            restResult = new RestResult<Object>(2001, e.getMessage(), null);
        }
        logger.debug("{}/delete/{} -> result: {}", new Object[]{this.getBasicUrl(), id, restResult});
        return restResult;
    }

    @RequestMapping(value={"/update"})
    public RestResult<Integer> update(@RequestBody T entity) {
        logger.debug("{}/update -> entity:{}", (Object)this.getBasicUrl(), entity);
        RestResult<Object> restResult = null;
        try {
            int count;
            String userId = this.sysService.getCurrentUserId();
            if (userId != null && ((BasicEntity)entity).getUpdateBy() == null) {
                ((BasicEntity)entity).setUpdateBy(userId);
            }
            restResult = (count = this.service.update(entity)) == 1 ? new RestResult<Integer>(2000, "\u66f4\u65b0\u6210\u529f", count) : new RestResult<Integer>(2001, "\u66f4\u65b0\u5931\u8d25\uff1a\u5173\u952e\u5b57\u91cd\u590d\uff1f", count);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            restResult = new RestResult<Object>(2001, e.getMessage(), null);
        }
        logger.debug("{}/update -> restResult:{}", (Object)this.getBasicUrl(), restResult);
        return restResult;
    }

    @RequestMapping(value={"/list"})
    public RestResult<PageInfo<T>> list(@RequestBody P param) {
        logger.debug("{}/list -> param:{}", (Object)this.getBasicUrl(), param);
        RestResult<Object> restResult = null;
        try {
            PageInfo<T> pageInfo = this.service.list(param);
            restResult = new RestResult<PageInfo<Object>>(2000, "\u83b7\u53d6\u6210\u529f", pageInfo);
        }
        catch (Exception e) {
            restResult = new RestResult<Object>(2001, e.getMessage(), null);
        }
        logger.debug("{}/list -> restResult:{}", (Object)this.getBasicUrl(), restResult);
        return restResult;
    }

    public abstract String getBasicUrl();
}

