/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.conf.entity.EppdevTable;
import cn.eppdev.jee.conf.param.EppdevTableParam;
import cn.eppdev.jee.conf.service.EppdevColumnService;
import cn.eppdev.jee.conf.service.EppdevConfService;
import cn.eppdev.jee.conf.service.EppdevIndexService;
import cn.eppdev.jee.conf.service.EppdevTableLogService;
import cn.eppdev.jee.conf.service.auto._EppdevTableService;
import cn.eppdev.jee.utils.NameUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EppdevTableService
extends _EppdevTableService {
    @Autowired
    EppdevColumnService columnService;
    @Autowired
    EppdevIndexService indexService;
    @Autowired
    EppdevConfService confService;
    @Autowired
    EppdevTableLogService tableLogService;

    @Override
    public void customeInit(EppdevTable entity) {
        String[] str;
        if (entity.getOriginTableId() == null || entity.getOriginTableId().length() == 0) {
            entity.setOriginTableId(entity.getId());
        }
        if (entity.getEntityName() == null || entity.getEntityName().length() == 0) {
            entity.setEntityName(NameUtils.getEntityName(entity.getTableName()));
        }
        if ((entity.getModuleName() == null || entity.getModuleName().length() == 0) && (str = entity.getTableName().split("_")).length > 1) {
            entity.setModuleName(str[0]);
        }
    }

    public List<EppdevTable> listByVersionId(String versionId) {
        EppdevTableParam param = new EppdevTableParam();
        param.setVersionId(versionId);
        param.buildOrderBy("module_name", "table_name");
        return this.list(param).getList();
    }

    @Override
    public EppdevTable get(String id) {
        EppdevTable table = (EppdevTable)super.get(id);
        if (table != null) {
            table.setColumnList(this.columnService.listByTableId(id));
            table.setIndexList(this.indexService.listByTableId(id));
            table.setBasicConf(this.confService.getAllConf());
            table.setLogList(this.tableLogService.listByTableId(id));
        }
        return table;
    }
}

