/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static Logger logger = LoggerFactory.getLogger(JSONUtils.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error("Error While Transform JavaBean to Json: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T readValue(String jsonStr, Class<T> cls) {
        try {
            return (T)objectMapper.readValue(jsonStr, cls);
        }
        catch (IOException e) {
            logger.error("Error While Transform JsonString to JavaBean: {}\n {}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return null;
        }
    }

    public static <T> T readValue(String jsonStr, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (IOException e) {
            logger.error("Error While Transform JsonString to JavaBean: {}\n {}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return null;
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

