/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.executor;

import cn.godmao.common.IExecute;
import cn.godmao.common.IRunnable;
import cn.godmao.common.ISelector;
import cn.godmao.common.ISubmit;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public interface IExecutorService<E extends ExecutorService>
extends IExecute<E>,
ISubmit<E>,
ISelector<E> {
    public E[] getExecutors();

    default public boolean isTerminated() {
        boolean isTerminated = true;
        for (ExecutorService executor : this.getExecutors()) {
            if (executor.isTerminated()) continue;
            isTerminated = false;
            break;
        }
        return isTerminated;
    }

    default public boolean isShutdown() {
        boolean isShutdown = true;
        for (ExecutorService executor : this.getExecutors()) {
            if (executor.isShutdown()) continue;
            isShutdown = false;
            break;
        }
        return isShutdown;
    }

    default public void shutdown() {
        for (ExecutorService executor : this.getExecutors()) {
            executor.shutdown();
        }
    }

    default public E select(Object key) {
        if (null == key) {
            return (E)((ExecutorService)this.next());
        }
        return (E)this.getExecutors()[Math.abs(key.hashCode() % this.getExecutors().length)];
    }

    default public void execute(Object key, IRunnable runnable) {
        this.execute((Executor)this.select(key), runnable);
    }

    default public void execute(IRunnable runnable) {
        this.execute((ExecutorService)this.next(), runnable);
    }

    default public Future<?> submit(Object key, IRunnable runnable) {
        return this.submit((ExecutorService)this.select(key), runnable);
    }

    default public <T> Future<T> submit(Object key, IRunnable task, T result) {
        return this.submit((ExecutorService)this.select(key), task, result);
    }

    default public <T> Future<T> submit(Object key, Callable<T> task) {
        return this.submit((ExecutorService)this.select(key), task);
    }

    default public Future<?> submit(IRunnable task) {
        return this.submit((ExecutorService)this.next(), task);
    }

    default public <T> Future<T> submit(IRunnable task, T result) {
        return this.submit((ExecutorService)this.next(), task, result);
    }

    default public <T> Future<T> submit(Callable<T> task) {
        return this.submit((ExecutorService)this.next(), task);
    }
}

