/*
 * Decompiled with CFR 0.152.
 */
package cn.letcode.utils.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    private static String defaultDateFormat = "yyyyMMdd";
    private static String defaultTimeFormat = "HHmmss";
    private static String defaultDateTimeFormat = "yyyyMMddHHmmss";

    public static String getCurrentDateTime() {
        Calendar cal = Calendar.getInstance();
        return new SimpleDateFormat(defaultDateTimeFormat).format(cal.getTime());
    }

    public static String getYesterdayDateTime() {
        return CalendarUtil.getYesterdayDateTime(defaultDateTimeFormat);
    }

    public static String getYesterdayDateTime(String format) {
        Calendar cal = CalendarUtil.getOffsetDay(-1);
        return new SimpleDateFormat(format).format(cal.getTime());
    }

    public static Calendar getOffsetDay(int offsetVal) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, offsetVal);
        return cal;
    }

    public static String getCurrentDateTime(String dateFormat) {
        return CalendarUtil.formatDateTime(CalendarUtil.getCurrentDateTime(), defaultDateTimeFormat, dateFormat);
    }

    public static String formatDate(String date) {
        return CalendarUtil.formatDate(date, defaultDateFormat);
    }

    public static String formatTime(String time) {
        return CalendarUtil.formatTime(time, defaultTimeFormat);
    }

    public static String formatDateTime(String datetime) {
        return CalendarUtil.formatDateTime(datetime, defaultDateTimeFormat);
    }

    public static String formatDate(String date, String dateFormat) {
        return CalendarUtil.formatDateTime(date, defaultDateFormat, dateFormat);
    }

    public static String formatTime(String time, String timeFormat) {
        return CalendarUtil.formatDateTime(time, defaultTimeFormat, timeFormat);
    }

    public static String formatDateTime(String datetime, String dateFormat) {
        return CalendarUtil.formatDateTime(datetime, defaultDateTimeFormat, dateFormat);
    }

    public static String formatDateTime(String datetime, String oldFormat, String newFormat) {
        try {
            Date date = new SimpleDateFormat(oldFormat).parse(datetime);
            return new SimpleDateFormat(newFormat).format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return datetime;
        }
    }
}

