/*
 * Decompiled with CFR 0.152.
 */
package cn.letcode.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtils {
    public static String beanToString(Object object) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        xstream.autodetectAnnotations(true);
        xstream.ignoreUnknownElements();
        return XmlUtils.formatXMLInOneLine(XmlUtils.appendHeadXml(xstream.toXML(object)));
    }

    public static Object xmlStrToBean(String xmlStr, Class bean, String rootName) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        xstream.autodetectAnnotations(true);
        xstream.ignoreUnknownElements();
        xstream.alias(rootName, bean);
        return xstream.fromXML(xmlStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXML(String inputXML) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(inputXML));
        String retXML = null;
        XMLWriter writer = null;
        if (document != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                OutputFormat format = new OutputFormat(" ", true);
                writer = new XMLWriter((Writer)stringWriter, format);
                writer.write(document);
                writer.flush();
                retXML = stringWriter.getBuffer().toString();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return retXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXMLInOneLine(String inputXML) {
        String retXml = "";
        XMLWriter writer = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(inputXML));
            if (document != null) {
                StringWriter stringWriter = new StringWriter();
                OutputFormat format = new OutputFormat("", false);
                format.setTrimText(true);
                format.setNewLineAfterDeclaration(false);
                writer = new XMLWriter((Writer)stringWriter, format);
                writer.write(document);
                writer.flush();
                retXml = stringWriter.getBuffer().toString();
            }
        }
        catch (IOException | DocumentException e) {
            String string = "";
            return string;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return retXml;
    }

    public static String appendHeadXml(String xml) {
        return XmlUtils.appendHeadXml(xml, "utf-8");
    }

    public static String appendHeadXml(String xml, String charset) {
        return "<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n" + (xml == null ? "" : xml);
    }
}

