/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.entity;

import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.Point;

public class OcrBox {
    private Point topLeft;
    private Point topRight;
    private Point bottomRight;
    private Point bottomLeft;

    public OcrBox(Point topLeft, Point topRight, Point bottomRight, Point bottomLeft) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    public OcrBox() {
    }

    public float[] toFloatArray() {
        return new float[]{(float)this.topLeft.getX(), (float)this.topLeft.getY(), (float)this.topRight.getX(), (float)this.topRight.getY(), (float)this.bottomRight.getX(), (float)this.bottomRight.getY(), (float)this.bottomLeft.getX(), (float)this.bottomLeft.getY()};
    }

    public DetectionRectangle toDetectionRectangle() {
        float[] pts = this.toFloatArray();
        float minX = Math.min(Math.min(pts[0], pts[2]), Math.min(pts[4], pts[6]));
        float minY = Math.min(Math.min(pts[1], pts[3]), Math.min(pts[5], pts[7]));
        float maxX = Math.max(Math.max(pts[0], pts[2]), Math.max(pts[4], pts[6]));
        float maxY = Math.max(Math.max(pts[1], pts[3]), Math.max(pts[5], pts[7]));
        DetectionRectangle rect = new DetectionRectangle();
        rect.setX((int)minX);
        rect.setY((int)minY);
        rect.setWidth((int)(maxX - minX));
        rect.setHeight((int)(maxY - minY));
        return rect;
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Point getTopRight() {
        return this.topRight;
    }

    public Point getBottomRight() {
        return this.bottomRight;
    }

    public Point getBottomLeft() {
        return this.bottomLeft;
    }

    public void setTopLeft(Point topLeft) {
        this.topLeft = topLeft;
    }

    public void setTopRight(Point topRight) {
        this.topRight = topRight;
    }

    public void setBottomRight(Point bottomRight) {
        this.bottomRight = bottomRight;
    }

    public void setBottomLeft(Point bottomLeft) {
        this.bottomLeft = bottomLeft;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OcrBox)) {
            return false;
        }
        OcrBox other = (OcrBox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Point this$topLeft = this.getTopLeft();
        Point other$topLeft = other.getTopLeft();
        if (this$topLeft == null ? other$topLeft != null : !this$topLeft.equals(other$topLeft)) {
            return false;
        }
        Point this$topRight = this.getTopRight();
        Point other$topRight = other.getTopRight();
        if (this$topRight == null ? other$topRight != null : !this$topRight.equals(other$topRight)) {
            return false;
        }
        Point this$bottomRight = this.getBottomRight();
        Point other$bottomRight = other.getBottomRight();
        if (this$bottomRight == null ? other$bottomRight != null : !this$bottomRight.equals(other$bottomRight)) {
            return false;
        }
        Point this$bottomLeft = this.getBottomLeft();
        Point other$bottomLeft = other.getBottomLeft();
        return !(this$bottomLeft == null ? other$bottomLeft != null : !this$bottomLeft.equals(other$bottomLeft));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OcrBox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Point $topLeft = this.getTopLeft();
        result = result * 59 + ($topLeft == null ? 43 : $topLeft.hashCode());
        Point $topRight = this.getTopRight();
        result = result * 59 + ($topRight == null ? 43 : $topRight.hashCode());
        Point $bottomRight = this.getBottomRight();
        result = result * 59 + ($bottomRight == null ? 43 : $bottomRight.hashCode());
        Point $bottomLeft = this.getBottomLeft();
        result = result * 59 + ($bottomLeft == null ? 43 : $bottomLeft.hashCode());
        return result;
    }

    public String toString() {
        return "OcrBox(topLeft=" + this.getTopLeft() + ", topRight=" + this.getTopRight() + ", bottomRight=" + this.getBottomRight() + ", bottomLeft=" + this.getBottomLeft() + ")";
    }
}

