/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.common.detect.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import cn.smartjavaai.ocr.opencv.OcrNDArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.RotatedRect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class PPOCRDetTranslator
implements Translator<Image, NDList> {
    private final float thresh = 0.3f;
    private final boolean use_dilation = false;
    private final String score_mode = "fast";
    private final String box_type = "quad";
    private final int limit_side_len;
    private final int max_candidates;
    private final int min_size;
    private final float box_thresh;
    private final float unclip_ratio;
    private float ratio_h;
    private float ratio_w;
    private int img_height;
    private int img_width;
    private String batchifier;

    public PPOCRDetTranslator(Map<String, ?> arguments) {
        this.limit_side_len = arguments.containsKey("limit_side_len") ? Integer.parseInt(arguments.get("limit_side_len").toString()) : 960;
        this.max_candidates = arguments.containsKey("max_candidates") ? Integer.parseInt(arguments.get("max_candidates").toString()) : 1000;
        this.min_size = arguments.containsKey("min_size") ? Integer.parseInt(arguments.get("min_size").toString()) : 3;
        this.box_thresh = arguments.containsKey("box_thresh") ? Float.parseFloat(arguments.get("box_thresh").toString()) : 0.6f;
        this.unclip_ratio = arguments.containsKey("unclip_ratio") ? Float.parseFloat(arguments.get("unclip_ratio").toString()) : 1.6f;
        this.batchifier = arguments.containsKey("batchifier") ? arguments.get("batchifier").toString() : "stack";
    }

    public NDList processOutput(TranslatorContext ctx, NDList list) {
        NDManager manager = ctx.getNDManager();
        NDArray pred = (NDArray)list.get(0);
        pred = pred.squeeze();
        NDArray segmentation = pred.gt((Number)Float.valueOf(0.3f));
        segmentation = segmentation.toType(DataType.UINT8, true);
        Shape shape = segmentation.getShape();
        int rows = (int)shape.get(0);
        int cols = (int)shape.get(1);
        Mat newMask = new Mat();
        this.getClass();
        Mat srcMat = OcrNDArrayUtils.uint8NDArrayToMat(segmentation);
        Scalar scalar = new Scalar(255.0);
        Core.multiply((Mat)srcMat, (Scalar)scalar, (Mat)newMask);
        srcMat.release();
        NDArray boxes = this.boxes_from_bitmap(manager, pred, newMask);
        NDArray boxes1 = boxes.get(":, :, 0", new Object[0]).div((Number)Float.valueOf(this.ratio_w));
        boxes.set(new NDIndex(":, :, 0", new Object[0]), boxes1);
        NDArray boxes2 = boxes.get(":, :, 1", new Object[0]).div((Number)Float.valueOf(this.ratio_h));
        boxes.set(new NDIndex(":, :, 1", new Object[0]), boxes2);
        NDList dt_boxes = this.filter_tag_det_res(boxes);
        dt_boxes.detach();
        newMask.release();
        return dt_boxes;
    }

    private NDList filter_tag_det_res(NDArray dt_boxes) {
        NDList boxesList = new NDList();
        int num = (int)dt_boxes.getShape().get(0);
        for (int i = 0; i < num; ++i) {
            NDArray box = dt_boxes.get(new long[]{i});
            box = this.order_points_clockwise(box);
            box = this.clip_det_res(box);
            float[] box0 = box.get(new long[]{0L}).toFloatArray();
            float[] box1 = box.get(new long[]{1L}).toFloatArray();
            float[] box3 = box.get(new long[]{3L}).toFloatArray();
            int rect_width = (int)Math.sqrt(Math.pow(box1[0] - box0[0], 2.0) + Math.pow(box1[1] - box0[1], 2.0));
            int rect_height = (int)Math.sqrt(Math.pow(box3[0] - box0[0], 2.0) + Math.pow(box3[1] - box0[1], 2.0));
            if (rect_width <= 3 || rect_height <= 3) continue;
            boxesList.add((Object)box);
        }
        return boxesList;
    }

    private NDArray clip_det_res(NDArray points) {
        int i = 0;
        while ((long)i < points.getShape().get(0)) {
            int value = Math.max((int)points.get(new long[]{i, 0L}).toFloatArray()[0], 0);
            value = Math.min(value, this.img_width - 1);
            points.set(new NDIndex(i + ",0", new Object[0]), (Number)value);
            value = Math.max((int)points.get(new long[]{i, 1L}).toFloatArray()[0], 0);
            value = Math.min(value, this.img_height - 1);
            points.set(new NDIndex(i + ",1", new Object[0]), (Number)value);
            ++i;
        }
        return points;
    }

    private NDArray order_points_clockwise(NDArray pts) {
        NDList list = new NDList();
        long[] indexes = pts.get(":, 0", new Object[0]).argSort().toLongArray();
        Shape s1 = pts.getShape();
        NDArray leftMost1 = pts.get(indexes[0] + ",:", new Object[0]);
        NDArray leftMost2 = pts.get(indexes[1] + ",:", new Object[0]);
        NDArray leftMost = leftMost1.concat(leftMost2).reshape(new long[]{2L, 2L});
        NDArray rightMost1 = pts.get(indexes[2] + ",:", new Object[0]);
        NDArray rightMost2 = pts.get(indexes[3] + ",:", new Object[0]);
        NDArray rightMost = rightMost1.concat(rightMost2).reshape(new long[]{2L, 2L});
        indexes = leftMost.get(":, 1", new Object[0]).argSort().toLongArray();
        NDArray lt = leftMost.get(indexes[0] + ",:", new Object[0]);
        NDArray lb = leftMost.get(indexes[1] + ",:", new Object[0]);
        indexes = rightMost.get(":, 1", new Object[0]).argSort().toLongArray();
        NDArray rt = rightMost.get(indexes[0] + ",:", new Object[0]);
        NDArray rb = rightMost.get(indexes[1] + ",:", new Object[0]);
        list.add((Object)lt);
        list.add((Object)rt);
        list.add((Object)rb);
        list.add((Object)lb);
        NDArray rect = NDArrays.concat((NDList)list).reshape(new long[]{4L, 2L});
        return rect;
    }

    private NDArray boxes_from_bitmap(NDManager manager, NDArray pred, Mat bitmap) {
        int dest_height = (int)pred.getShape().get(0);
        int dest_width = (int)pred.getShape().get(1);
        int height = bitmap.rows();
        int width = bitmap.cols();
        ArrayList contours = new ArrayList();
        Mat hierarchy = new Mat();
        Imgproc.findContours((Mat)bitmap, contours, (Mat)hierarchy, (int)1, (int)2);
        int num_contours = Math.min(contours.size(), this.max_candidates);
        NDList boxList = new NDList();
        float[] scores = new float[num_contours];
        for (int index = 0; index < num_contours; ++index) {
            NDArray points;
            float score;
            float[][] pointsArr;
            MatOfPoint contour = (MatOfPoint)contours.get(index);
            MatOfPoint2f newContour = new MatOfPoint2f(contour.toArray());
            int sside = this.get_mini_boxes(newContour, pointsArr = new float[4][2]);
            if (sside < this.min_size || (score = this.box_score_fast(manager, pred, points = manager.create(pointsArr))) < this.box_thresh) continue;
            NDArray box = this.unclip(manager, points);
            NDArray boxes1 = box.get(":,0", new Object[0]).div((Number)width).mul((Number)dest_width).round().clip((Number)0, (Number)dest_width);
            box.set(new NDIndex(":, 0", new Object[0]), boxes1);
            NDArray boxes2 = box.get(":,1", new Object[0]).div((Number)height).mul((Number)dest_height).round().clip((Number)0, (Number)dest_height);
            box.set(new NDIndex(":, 1", new Object[0]), boxes2);
            boxList.add((Object)box);
            scores[index] = score;
            contour.release();
            newContour.release();
        }
        NDArray boxes = NDArrays.stack((NDList)boxList);
        hierarchy.release();
        return boxes;
    }

    private NDArray unclip(NDManager manager, NDArray points) {
        float height;
        points = this.order_points_clockwise(points);
        float[] pointsArr = points.toFloatArray();
        float[] lt = Arrays.copyOfRange(pointsArr, 0, 2);
        float[] lb = Arrays.copyOfRange(pointsArr, 6, 8);
        float[] rt = Arrays.copyOfRange(pointsArr, 2, 4);
        float[] rb = Arrays.copyOfRange(pointsArr, 4, 6);
        float width = this.distance(lt, rt);
        if (width > (height = this.distance(lt, lb))) {
            float k = (lt[1] - rt[1]) / (lt[0] - rt[0]);
            float delta_dis = height;
            float delta_x = (float)Math.sqrt(delta_dis * delta_dis / (k * k + 1.0f));
            float delta_y = Math.abs(k * delta_x);
            if (k > 0.0f) {
                pointsArr[0] = lt[0] - delta_x + delta_y;
                pointsArr[1] = lt[1] - delta_y - delta_x;
                pointsArr[2] = rt[0] + delta_x + delta_y;
                pointsArr[3] = rt[1] + delta_y - delta_x;
                pointsArr[4] = rb[0] + delta_x - delta_y;
                pointsArr[5] = rb[1] + delta_y + delta_x;
                pointsArr[6] = lb[0] - delta_x - delta_y;
                pointsArr[7] = lb[1] - delta_y + delta_x;
            } else {
                pointsArr[0] = lt[0] - delta_x - delta_y;
                pointsArr[1] = lt[1] + delta_y - delta_x;
                pointsArr[2] = rt[0] + delta_x - delta_y;
                pointsArr[3] = rt[1] - delta_y - delta_x;
                pointsArr[4] = rb[0] + delta_x + delta_y;
                pointsArr[5] = rb[1] - delta_y + delta_x;
                pointsArr[6] = lb[0] - delta_x + delta_y;
                pointsArr[7] = lb[1] + delta_y + delta_x;
            }
        } else {
            float k = (lt[1] - rt[1]) / (lt[0] - rt[0]);
            float delta_dis = width;
            float delta_y = (float)Math.sqrt(delta_dis * delta_dis / (k * k + 1.0f));
            float delta_x = Math.abs(k * delta_y);
            if (k > 0.0f) {
                pointsArr[0] = lt[0] + delta_x - delta_y;
                pointsArr[1] = lt[1] - delta_y - delta_x;
                pointsArr[2] = rt[0] + delta_x + delta_y;
                pointsArr[3] = rt[1] - delta_y + delta_x;
                pointsArr[4] = rb[0] - delta_x + delta_y;
                pointsArr[5] = rb[1] + delta_y + delta_x;
                pointsArr[6] = lb[0] - delta_x - delta_y;
                pointsArr[7] = lb[1] + delta_y - delta_x;
            } else {
                pointsArr[0] = lt[0] - delta_x - delta_y;
                pointsArr[1] = lt[1] - delta_y + delta_x;
                pointsArr[2] = rt[0] - delta_x + delta_y;
                pointsArr[3] = rt[1] - delta_y - delta_x;
                pointsArr[4] = rb[0] + delta_x + delta_y;
                pointsArr[5] = rb[1] + delta_y - delta_x;
                pointsArr[6] = lb[0] + delta_x - delta_y;
                pointsArr[7] = lb[1] + delta_y + delta_x;
            }
        }
        points = manager.create(pointsArr).reshape(new long[]{4L, 2L});
        return points;
    }

    private float distance(float[] point1, float[] point2) {
        float disX = point1[0] - point2[0];
        float disY = point1[1] - point2[1];
        float dis = (float)Math.sqrt(disX * disX + disY * disY);
        return dis;
    }

    private int get_mini_boxes(MatOfPoint2f contour, float[][] pointsArr) {
        RotatedRect rect = Imgproc.minAreaRect((MatOfPoint2f)contour);
        Mat points = new Mat();
        Imgproc.boxPoints((RotatedRect)rect, (Mat)points);
        float[][] fourPoints = new float[4][2];
        for (int row = 0; row < 4; ++row) {
            fourPoints[row][0] = (float)points.get(row, 0)[0];
            fourPoints[row][1] = (float)points.get(row, 1)[0];
        }
        float[] tmpPoint = new float[2];
        for (int i = 0; i < 4; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (!(fourPoints[j][0] < fourPoints[i][0])) continue;
                tmpPoint[0] = fourPoints[i][0];
                tmpPoint[1] = fourPoints[i][1];
                fourPoints[i][0] = fourPoints[j][0];
                fourPoints[i][1] = fourPoints[j][1];
                fourPoints[j][0] = tmpPoint[0];
                fourPoints[j][1] = tmpPoint[1];
            }
        }
        int index_1 = 0;
        int index_2 = 1;
        int index_3 = 2;
        int index_4 = 3;
        if (fourPoints[1][1] > fourPoints[0][1]) {
            index_1 = 0;
            index_4 = 1;
        } else {
            index_1 = 1;
            index_4 = 0;
        }
        if (fourPoints[3][1] > fourPoints[2][1]) {
            index_2 = 2;
            index_3 = 3;
        } else {
            index_2 = 3;
            index_3 = 2;
        }
        pointsArr[0] = fourPoints[index_1];
        pointsArr[1] = fourPoints[index_2];
        pointsArr[2] = fourPoints[index_3];
        pointsArr[3] = fourPoints[index_4];
        int height = rect.boundingRect().height;
        int width = rect.boundingRect().width;
        int sside = Math.min(height, width);
        points.release();
        return sside;
    }

    private float box_score_fast(NDManager manager, NDArray bitmap, NDArray points) {
        NDArray box = points.get(":", new Object[0]);
        long h = bitmap.getShape().get(0);
        long w = bitmap.getShape().get(1);
        int xmin = box.get(":, 0", new Object[0]).min().floor().clip((Number)0, (Number)(w - 1L)).toType(DataType.INT32, true).toIntArray()[0];
        int xmax = box.get(":, 0", new Object[0]).max().ceil().clip((Number)0, (Number)(w - 1L)).toType(DataType.INT32, true).toIntArray()[0];
        int ymin = box.get(":, 1", new Object[0]).min().floor().clip((Number)0, (Number)(h - 1L)).toType(DataType.INT32, true).toIntArray()[0];
        int ymax = box.get(":, 1", new Object[0]).max().ceil().clip((Number)0, (Number)(h - 1L)).toType(DataType.INT32, true).toIntArray()[0];
        NDArray mask = manager.zeros(new Shape(new long[]{ymax - ymin + 1, xmax - xmin + 1}), DataType.UINT8);
        box.set(new NDIndex(":, 0", new Object[0]), box.get(":, 0", new Object[0]).sub((Number)xmin));
        box.set(new NDIndex(":, 1", new Object[0]), box.get(":, 1", new Object[0]).sub((Number)ymin));
        Mat maskMat = OcrNDArrayUtils.uint8NDArrayToMat(mask);
        Mat boxMat = OcrNDArrayUtils.floatNDArrayToMat(box, 4);
        ArrayList<MatOfPoint> pts = new ArrayList<MatOfPoint>();
        MatOfPoint matOfPoint = OcrNDArrayUtils.matToMatOfPoint(boxMat);
        pts.add(matOfPoint);
        Imgproc.fillPoly((Mat)maskMat, pts, (Scalar)new Scalar(1.0));
        NDArray subBitMap = bitmap.get(ymin + ":" + (ymax + 1) + "," + xmin + ":" + (xmax + 1), new Object[0]);
        Mat bitMapMat = OcrNDArrayUtils.floatNDArrayToMat(subBitMap);
        Scalar score = Core.mean((Mat)bitMapMat, (Mat)maskMat);
        float scoreValue = (float)score.val[0];
        maskMat.release();
        boxMat.release();
        bitMapMat.release();
        return scoreValue;
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray img = input.toNDArray(ctx.getNDManager());
        int h = input.getHeight();
        int w = input.getWidth();
        this.img_height = h;
        this.img_width = w;
        float ratio = 1.0f;
        if (Math.max(h, w) > this.limit_side_len) {
            ratio = h > w ? (float)this.limit_side_len / (float)h : (float)this.limit_side_len / (float)w;
        }
        int resize_h = (int)((float)h * ratio);
        int resize_w = (int)((float)w * ratio);
        resize_h = Math.round((float)resize_h / 32.0f) * 32;
        resize_w = Math.round((float)resize_w / 32.0f) * 32;
        this.ratio_h = (float)resize_h / (float)h;
        this.ratio_w = (float)resize_w / (float)w;
        img = NDImageUtils.resize((NDArray)img, (int)resize_w, (int)resize_h);
        img = NDImageUtils.toTensor((NDArray)img);
        img = NDImageUtils.normalize((NDArray)img, (float[])new float[]{0.485f, 0.456f, 0.406f}, (float[])new float[]{0.229f, 0.224f, 0.225f});
        return new NDList(new NDArray[]{img});
    }

    public Batchifier getBatchifier() {
        return Batchifier.fromString((String)this.batchifier);
    }
}

