/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.plate.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import cn.smartjavaai.common.utils.LetterBoxUtils;
import cn.smartjavaai.common.utils.NMSUtils;
import java.util.ArrayList;
import java.util.Map;

public class Yolov8PlateDetectTranslator
implements Translator<Image, DetectedObjects> {
    private int inputSize = 640;
    private float minConfThreshold = 0.3f;
    private float iouThreshold = 0.5f;
    private float confThreshold = 0.0f;
    private int imageWidth;
    private int imageHeight;
    private int topK;
    private LetterBoxUtils.ResizeResult letterBoxResult;

    public Yolov8PlateDetectTranslator(Map<String, ?> arguments) {
        this.confThreshold = arguments.containsKey("confThreshold") ? (float)Integer.parseInt(arguments.get("confThreshold").toString()) : 0.3f;
        this.iouThreshold = arguments.containsKey("iouThreshold") ? (float)Integer.parseInt(arguments.get("iouThreshold").toString()) : 0.5f;
        this.topK = arguments.containsKey("topk") ? Integer.parseInt(arguments.get("topk").toString()) : 100;
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDManager manager = ctx.getNDManager();
        NDArray array = input.toNDArray(manager, Image.Flag.COLOR);
        this.imageWidth = (int)array.getShape().get(1);
        this.imageHeight = (int)array.getShape().get(0);
        this.letterBoxResult = LetterBoxUtils.letterbox((NDManager)manager, (NDArray)array, (int)this.inputSize, (int)this.inputSize, (float)114.0f, (LetterBoxUtils.PaddingPosition)LetterBoxUtils.PaddingPosition.CENTER);
        array = this.letterBoxResult.image;
        array = array.toType(DataType.FLOAT32, false).div((Number)Float.valueOf(255.0f));
        array = array.transpose(new int[]{2, 0, 1});
        return new NDList(new NDArray[]{array.expandDims(0)});
    }

    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) {
        NDManager manager = ctx.getNDManager();
        NDArray preds = (NDArray)list.get(0);
        preds = preds.squeeze(0).transpose(new int[]{1, 0});
        NDArray classScores = preds.get(":, 4:6", new Object[0]);
        NDArray maxScores = classScores.max(new int[]{1});
        NDArray confMask = maxScores.gt((Number)Float.valueOf(this.minConfThreshold));
        if ((preds = preds.get(confMask)).isEmpty()) {
            return null;
        }
        NDArray boxes = preds.get(":, 0:4", new Object[0]);
        boxes = Yolov8PlateDetectTranslator.xywh2xyxy(boxes);
        NDArray scoresAndClasses = preds.get(":, 4:6", new Object[0]);
        NDArray scores = scoresAndClasses.max(new int[]{1}, true);
        NDArray index = scoresAndClasses.argMax(1).expandDims(1);
        NDArray result = NDArrays.concat((NDList)new NDList(new NDArray[]{boxes, scores, index}), (int)1);
        int[] keepIndices = NMSUtils.nms((NDArray)boxes, (NDArray)scores.squeeze(), (float)this.iouThreshold);
        NDArray kept = result.get(manager.create(keepIndices));
        if (keepIndices.length > this.topK) {
            int[] topkIndices = new int[this.topK];
            System.arraycopy(keepIndices, 0, topkIndices, 0, this.topK);
            keepIndices = topkIndices;
        }
        NDArray restored = LetterBoxUtils.restoreBox((NDArray)kept, (float)this.letterBoxResult.r, (float)this.letterBoxResult.left, (float)this.letterBoxResult.top, (int)5, (int)0);
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<Double> probabilities = new ArrayList<Double>();
        ArrayList<Rectangle> boundingBoxes = new ArrayList<Rectangle>();
        float[] flatData = restored.toFloatArray();
        long[] shape = restored.getShape().getShape();
        int rows = (int)shape[0];
        int cols = (int)shape[1];
        float[][] data = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(flatData, i * cols, data[i], 0, cols);
        }
        for (float[] row : data) {
            float x1 = row[0];
            float y1 = row[1];
            float x2 = row[2];
            float y2 = row[3];
            float score = row[4];
            int classIndex = (int)row[5];
            double prob = score;
            String className = classIndex == 0 ? "single" : "double";
            double rectX = x1 / (float)this.imageWidth;
            double rectY = y1 / (float)this.imageHeight;
            double rectW = (x2 - x1) / (float)this.imageWidth;
            double rectH = (y2 - y1) / (float)this.imageHeight;
            Rectangle rectangle = new Rectangle(rectX, rectY, rectW, rectH);
            classNames.add(className);
            probabilities.add(prob);
            boundingBoxes.add(rectangle);
        }
        DetectedObjects detectedObjects = new DetectedObjects(classNames, probabilities, boundingBoxes);
        return detectedObjects;
    }

    public Batchifier getBatchifier() {
        return null;
    }

    public static NDArray xywh2xyxy(NDArray xywh) {
        NDArray x = xywh.get(":, 0", new Object[0]);
        NDArray y = xywh.get(":, 1", new Object[0]);
        NDArray w = xywh.get(":, 2", new Object[0]).div((Number)2);
        NDArray h = xywh.get(":, 3", new Object[0]).div((Number)2);
        NDArray x1 = x.sub(w);
        NDArray y1 = y.sub(h);
        NDArray x2 = x.add(w);
        NDArray y2 = y.add(h);
        return NDArrays.stack((NDList)new NDList(new NDArray[]{x1, y1, x2, y2}), (int)1);
    }
}

