/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.bean.copier;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.PropDesc;
import cn.ujava.common.bean.copier.AbsCopier;
import cn.ujava.common.bean.copier.CopyOptions;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.lang.mutable.MutableEntry;
import cn.ujava.common.reflect.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanToMapCopier
extends AbsCopier<Object, Map> {
    private final Type targetType;

    public BeanToMapCopier(Object source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public Map copy() {
        Class<?> actualEditable = this.source.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.source), "Source class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> sourcePropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(this.copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<String, Object> entry = this.copyOptions.editField((String)sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = entry.getKey();
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            Type[] typeArguments = TypeUtil.getTypeArguments(this.targetType);
            if (null != typeArguments) {
                sValue = this.copyOptions.convertField(typeArguments[1], sValue);
            }
            if (null != sValue || !this.copyOptions.ignoreNullValue) {
                ((Map)this.target).put(sFieldName, sValue);
            }
        });
        return (Map)this.target;
    }
}

