/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.codec.hash.metro;

import cn.ujava.common.codec.hash.metro.MetroHash;
import java.nio.ByteBuffer;

public abstract class AbstractMetroHash<R extends AbstractMetroHash<R>>
implements MetroHash<R> {
    final long seed;
    long v0;
    long v1;
    long v2;
    long v3;
    long nChunks;

    public AbstractMetroHash(long seed) {
        this.seed = seed;
        this.reset();
    }

    @Override
    public R apply(ByteBuffer input) {
        this.reset();
        while (input.remaining() >= 32) {
            this.partialApply32ByteChunk(input);
        }
        return this.partialApplyRemaining(input);
    }

    abstract R partialApply32ByteChunk(ByteBuffer var1);

    abstract R partialApplyRemaining(ByteBuffer var1);

    static long grab(ByteBuffer bb, int length) {
        long result = (long)bb.get() & 0xFFL;
        for (int i = 1; i < length; ++i) {
            result |= ((long)bb.get() & 0xFFL) << (i << 3);
        }
        return result;
    }

    static void writeLittleEndian(long hash, ByteBuffer output) {
        for (int i = 0; i < 8; ++i) {
            output.put((byte)(hash >>> i * 8));
        }
    }
}

