/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.codec.hash.metro;

import cn.ujava.common.codec.hash.Hash64;
import cn.ujava.common.codec.hash.metro.AbstractMetroHash;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MetroHash64
extends AbstractMetroHash<MetroHash64>
implements Hash64<byte[]> {
    private static final long K0 = 3603962101L;
    private static final long K1 = 2729050939L;
    private static final long K2 = 1654206401L;
    private static final long K3 = 817650473L;
    private long hash;

    public static MetroHash64 of(long seed) {
        return new MetroHash64(seed);
    }

    public MetroHash64(long seed) {
        super(seed);
    }

    @Override
    public MetroHash64 reset() {
        this.v3 = this.hash = (this.seed + 1654206401L) * 3603962101L;
        this.v2 = this.hash;
        this.v1 = this.hash;
        this.v0 = this.hash;
        this.nChunks = 0L;
        return this;
    }

    public long get() {
        return this.hash;
    }

    @Override
    public long hash64(byte[] bytes) {
        return ((MetroHash64)this.apply(ByteBuffer.wrap(bytes))).get();
    }

    @Override
    public MetroHash64 write(ByteBuffer output, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            MetroHash64.writeLittleEndian(this.hash, output);
        } else {
            output.asLongBuffer().put(this.hash);
        }
        return this;
    }

    @Override
    MetroHash64 partialApply32ByteChunk(ByteBuffer partialInput) {
        assert (partialInput.remaining() >= 32);
        this.v0 += MetroHash64.grab(partialInput, 8) * 3603962101L;
        this.v0 = Long.rotateRight(this.v0, 29) + this.v2;
        this.v1 += MetroHash64.grab(partialInput, 8) * 2729050939L;
        this.v1 = Long.rotateRight(this.v1, 29) + this.v3;
        this.v2 += MetroHash64.grab(partialInput, 8) * 1654206401L;
        this.v2 = Long.rotateRight(this.v2, 29) + this.v0;
        this.v3 += MetroHash64.grab(partialInput, 8) * 817650473L;
        this.v3 = Long.rotateRight(this.v3, 29) + this.v1;
        ++this.nChunks;
        return this;
    }

    @Override
    MetroHash64 partialApplyRemaining(ByteBuffer partialInput) {
        assert (partialInput.remaining() < 32);
        if (this.nChunks > 0L) {
            this.metroHash64_32();
        }
        if (partialInput.remaining() >= 16) {
            this.metroHash64_16(partialInput);
        }
        if (partialInput.remaining() >= 8) {
            this.metroHash64_8(partialInput);
        }
        if (partialInput.remaining() >= 4) {
            this.metroHash64_4(partialInput);
        }
        if (partialInput.remaining() >= 2) {
            this.metroHash64_2(partialInput);
        }
        if (partialInput.remaining() >= 1) {
            this.metroHash64_1(partialInput);
        }
        this.hash ^= Long.rotateRight(this.hash, 28);
        this.hash *= 3603962101L;
        this.hash ^= Long.rotateRight(this.hash, 29);
        return this;
    }

    private void metroHash64_32() {
        this.v2 ^= Long.rotateRight((this.v0 + this.v3) * 3603962101L + this.v1, 37) * 2729050939L;
        this.v3 ^= Long.rotateRight((this.v1 + this.v2) * 2729050939L + this.v0, 37) * 3603962101L;
        this.v0 ^= Long.rotateRight((this.v0 + this.v2) * 3603962101L + this.v3, 37) * 2729050939L;
        this.v1 ^= Long.rotateRight((this.v1 + this.v3) * 2729050939L + this.v2, 37) * 3603962101L;
        this.hash += this.v0 ^ this.v1;
    }

    private void metroHash64_16(ByteBuffer bb) {
        this.v0 = this.hash + MetroHash64.grab(bb, 8) * 1654206401L;
        this.v0 = Long.rotateRight(this.v0, 29) * 817650473L;
        this.v1 = this.hash + MetroHash64.grab(bb, 8) * 1654206401L;
        this.v1 = Long.rotateRight(this.v1, 29) * 817650473L;
        this.v0 ^= Long.rotateRight(this.v0 * 3603962101L, 21) + this.v1;
        this.v1 ^= Long.rotateRight(this.v1 * 817650473L, 21) + this.v0;
        this.hash += this.v1;
    }

    private void metroHash64_8(ByteBuffer bb) {
        this.hash += MetroHash64.grab(bb, 8) * 817650473L;
        this.hash ^= Long.rotateRight(this.hash, 55) * 2729050939L;
    }

    private void metroHash64_4(ByteBuffer bb) {
        this.hash += MetroHash64.grab(bb, 4) * 817650473L;
        this.hash ^= Long.rotateRight(this.hash, 26) * 2729050939L;
    }

    private void metroHash64_2(ByteBuffer bb) {
        this.hash += MetroHash64.grab(bb, 2) * 817650473L;
        this.hash ^= Long.rotateRight(this.hash, 48) * 2729050939L;
    }

    private void metroHash64_1(ByteBuffer bb) {
        this.hash += MetroHash64.grab(bb, 1) * 817650473L;
        this.hash ^= Long.rotateRight(this.hash, 37) * 2729050939L;
    }
}

