/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.collection.set;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.collection.set.SetFromMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SetUtil {
    public static <T> HashSet<T> of(boolean isLinked) {
        return SetUtil._of(isLinked, null);
    }

    @SafeVarargs
    public static <T> HashSet<T> of(T ... ts) {
        return SetUtil._of(false, ts);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> ofLinked(T ... ts) {
        return (LinkedHashSet)SetUtil._of(true, ts);
    }

    public static <T> HashSet<T> of(Iterable<T> iterable) {
        return SetUtil.of(false, iterable);
    }

    public static <T> HashSet<T> of(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return SetUtil.of(isLinked);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return isLinked ? new LinkedHashSet(collection) : new HashSet(collection);
        }
        return SetUtil.of(isLinked, iterable.iterator());
    }

    public static <T> HashSet<T> of(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return SetUtil._of(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> of(boolean isLinked, Enumeration<T> enumeration) {
        HashSet set;
        if (null == enumeration) {
            return SetUtil._of(isLinked, null);
        }
        HashSet hashSet = set = isLinked ? new LinkedHashSet() : new HashSet();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static <T> SetFromMap<T> of(Map<T, Boolean> map) {
        return new SetFromMap<T>(map);
    }

    @SafeVarargs
    public static <T> Set<T> view(T ... ts) {
        return SetUtil.view(SetUtil.of(ts));
    }

    public static <T> Set<T> view(Set<T> ts) {
        if (ArrayUtil.isEmpty(ts)) {
            return SetUtil.empty();
        }
        return Collections.unmodifiableSet(ts);
    }

    public static <T> Set<T> empty() {
        return Collections.emptySet();
    }

    public static <T> Set<T> zero() {
        return new HashSet(0, 1.0f);
    }

    public static <T> Set<T> zeroLinked() {
        return new LinkedHashSet(0, 1.0f);
    }

    public static <T> Set<T> unmodifiable(Set<? extends T> c) {
        if (null == c) {
            return null;
        }
        return Collections.unmodifiableSet(c);
    }

    private static <T> HashSet<T> _of(boolean isLinked, T[] ts) {
        if (ArrayUtil.isEmpty(ts)) {
            return isLinked ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isLinked ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }
}

