/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.copier.BeanCopier;
import cn.ujava.common.bean.copier.CopyOptions;
import cn.ujava.common.bean.copier.ValueProvider;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.Converter;
import cn.ujava.common.io.SerializeUtil;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.map.MapProxy;
import cn.ujava.common.reflect.ConstructorUtil;
import cn.ujava.common.reflect.TypeUtil;
import cn.ujava.common.text.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static BeanConverter INSTANCE = new BeanConverter();
    private final CopyOptions copyOptions;

    public BeanConverter() {
        this(CopyOptions.of().setIgnoreError(true));
    }

    public BeanConverter(CopyOptions copyOptions) {
        this.copyOptions = copyOptions;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isWritableBean(value.getClass())) {
            if (value instanceof Map && targetClass.isInterface()) {
                return MapProxy.of((Map)value).toProxyBean(targetClass);
            }
            return BeanCopier.of(value, ConstructorUtil.newInstanceIfPossible(targetClass), targetType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return SerializeUtil.deserialize((byte[])value, new Class[0]);
        }
        if (StrUtil.isEmptyIfStr(value)) {
            return null;
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

