/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.copier.ValueProvider;
import cn.ujava.common.bean.copier.provider.BeanValueProvider;
import cn.ujava.common.bean.copier.provider.MapValueProvider;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.Converter;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.reflect.TypeUtil;
import cn.ujava.common.reflect.kotlin.KClassUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;

public class KBeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static KBeanConverter INSTANCE = new KBeanConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        ValueProvider valueProvider = null;
        if (value instanceof ValueProvider) {
            valueProvider = (ValueProvider)value;
        } else if (value instanceof Map) {
            valueProvider = new MapValueProvider((Map)value);
        } else if (BeanUtil.isWritableBean(value.getClass())) {
            valueProvider = new BeanValueProvider(value);
        }
        if (null != valueProvider) {
            return KClassUtil.newInstance(targetClass, valueProvider);
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

