/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.convert.CompositeConverter;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.Converter;
import cn.ujava.common.lang.tuple.Pair;
import cn.ujava.common.map.MapUtil;
import cn.ujava.common.reflect.TypeReference;
import cn.ujava.common.reflect.TypeUtil;
import cn.ujava.common.text.StrUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class PairConverter
implements Converter {
    public static final PairConverter INSTANCE = new PairConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeUtil.getTypeArgument(targetType, 0);
        Type rightType = TypeUtil.getTypeArgument(targetType, 1);
        return this.convert(leftType, rightType, value);
    }

    public Pair<?, ?> convert(Type leftType, Type rightType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = MapUtil.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Pair) {
            Pair entry = (Pair)value;
            map = MapUtil.of(entry.getLeft(), entry.getRight());
        } else if (value instanceof Map) {
            map = (Map)value;
        } else if (value instanceof CharSequence) {
            CharSequence str = (CharSequence)value;
            map = PairConverter.strToMap(str);
        } else if (BeanUtil.isReadableBean(value.getClass())) {
            map = BeanUtil.beanToMap(value, new String[0]);
        }
        if (null != map) {
            return PairConverter.mapToPair(leftType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence str) {
        int index = StrUtil.indexOf(str, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, str.length());
        if (index > -1) {
            return MapUtil.of(str.subSequence(0, index), str.subSequence(index + 1, str.length()));
        }
        return null;
    }

    private static Pair<?, ?> mapToPair(Type keyType, Type valueType, Map map) {
        Object left = null;
        Object right = null;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            left = entry.getKey();
            right = entry.getValue();
        } else if (2 == map.size()) {
            left = map.get("left");
            right = map.get("right");
        }
        CompositeConverter convert = CompositeConverter.getInstance();
        return Pair.of(TypeUtil.isUnknown(keyType) ? left : convert.convert(keyType, left), TypeUtil.isUnknown(valueType) ? right : convert.convert(valueType, right));
    }
}

