/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.convert.CompositeConverter;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.Converter;
import cn.ujava.common.lang.tuple.Triple;
import cn.ujava.common.reflect.TypeReference;
import cn.ujava.common.reflect.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class TripleConverter
implements Converter {
    public static final TripleConverter INSTANCE = new TripleConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeUtil.getTypeArgument(targetType, 0);
        Type middileType = TypeUtil.getTypeArgument(targetType, 1);
        Type rightType = TypeUtil.getTypeArgument(targetType, 2);
        return this.convert(leftType, middileType, rightType, value);
    }

    public Triple<?, ?, ?> convert(Type leftType, Type middleType, Type rightType, Object value) throws ConvertException {
        Map<String, Object> map = null;
        if (BeanUtil.isReadableBean(value.getClass())) {
            map = BeanUtil.beanToMap(value, new String[0]);
        }
        if (null != map) {
            return TripleConverter.mapToTriple(leftType, middleType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Triple<?, ?, ?> mapToTriple(Type leftType, Type middleType, Type rightType, Map map) {
        Object left = map.get("left");
        Object middle = map.get("middle");
        Object right = map.get("right");
        CompositeConverter convert = CompositeConverter.getInstance();
        return Triple.of(TypeUtil.isUnknown(leftType) ? left : convert.convert(leftType, left), TypeUtil.isUnknown(middleType) ? middle : convert.convert(middleType, middle), TypeUtil.isUnknown(rightType) ? right : convert.convert(rightType, right));
    }
}

