/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.data;

import cn.ujava.common.data.CIN;
import cn.ujava.common.date.DateTime;
import cn.ujava.common.date.DateUtil;
import cn.ujava.common.text.StrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IdcardUtil {
    private static final Map<Character, Integer> TW_FIRST_CODE = new HashMap<Character, Integer>();

    public static String convert15To18(String idCard) {
        return CIN.convert15To18(idCard);
    }

    public static String convert18To15(String idCard) {
        return CIN.convert18To15(idCard);
    }

    public static boolean isValidCard(String idCard) {
        if (StrUtil.isBlank(idCard)) {
            return false;
        }
        int length = idCard.length();
        switch (length) {
            case 18: {
                return IdcardUtil.isValidCard18(idCard);
            }
            case 15: {
                try {
                    return IdcardUtil.isValidCard18(CIN.convert15To18(idCard));
                }
                catch (Exception ignore) {
                    return false;
                }
            }
            case 10: {
                String[] cardVal = IdcardUtil.isValidCard10(idCard);
                return null != cardVal && "true".equals(cardVal[2]);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idcard) {
        return IdcardUtil.isValidCard18(idcard, true);
    }

    public static boolean isValidCard18(String idcard, boolean ignoreCase) {
        return CIN.verify(idcard, ignoreCase);
    }

    public static String[] isValidCard10(String idcard) {
        if (StrUtil.isBlank(idcard)) {
            return null;
        }
        String[] info = new String[3];
        String card = idcard.replaceAll("[()]", "");
        if (card.length() != 8 && card.length() != 9 && idcard.length() != 10) {
            return null;
        }
        if (idcard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            char char2 = idcard.charAt(1);
            if ('1' == char2) {
                info[1] = "M";
            } else if ('2' == char2) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = IdcardUtil.isValidTWCard(idcard) ? "true" : "false";
        } else if (idcard.matches("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
            info[2] = "true";
        } else if (idcard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IdcardUtil.isValidHKCard(idcard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean isValidTWCard(String idcard) {
        if (null == idcard || idcard.length() != 10) {
            return false;
        }
        Integer iStart = TW_FIRST_CODE.get(Character.valueOf(idcard.charAt(0)));
        if (null == iStart) {
            return false;
        }
        int sum = iStart / 10 + iStart % 10 * 9;
        String mid = idcard.substring(1, 9);
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        String end = idcard.substring(9, 10);
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    public static boolean isValidHKCard(String idcard) {
        int sum;
        if (StrUtil.isBlank(idcard)) {
            return false;
        }
        String card = idcard.replaceAll("[()]", "");
        if (card.length() == 9) {
            sum = (Character.toUpperCase(card.charAt(0)) - 55) * 9 + (Character.toUpperCase(card.charAt(1)) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Character.toUpperCase(card.charAt(0)) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    public static String getBirth(String idCard) {
        return IdcardUtil.getCIN(idCard).getBirth();
    }

    public static DateTime getBirthDate(String idCard) {
        return IdcardUtil.getCIN(idCard).getBirthDate();
    }

    public static int getAge(String idcard) {
        return IdcardUtil.getAge(idcard, DateUtil.now());
    }

    public static int getAge(String idcard, Date dateToCompare) {
        return DateUtil.age(IdcardUtil.getBirthDate(idcard), dateToCompare);
    }

    public static Short getBirthYear(String idcard) {
        return IdcardUtil.getCIN(idcard).getBirthYear();
    }

    public static Short getBirthMonth(String idcard) {
        return IdcardUtil.getCIN(idcard).getBirthMonth();
    }

    public static Short getBirthDay(String idcard) {
        return IdcardUtil.getCIN(idcard).getBirthDay();
    }

    public static int getGender(String idcard) {
        return IdcardUtil.getCIN(idcard).getGender();
    }

    public static String getProvinceCode(String idcard) {
        return IdcardUtil.getCIN(idcard).getProvinceCode();
    }

    public static String getProvince(String idcard) {
        return IdcardUtil.getCIN(idcard).getProvince();
    }

    public static String getCityCode(String idcard) {
        return IdcardUtil.getCIN(idcard).getCityCode();
    }

    public static String getDistrictCode(String idcard) {
        return IdcardUtil.getCIN(idcard).getDistrictCode();
    }

    public static String hide(String idcard, int startInclude, int endExclude) {
        return StrUtil.hide(idcard, startInclude, endExclude);
    }

    public static CIN getCIN(String idcard) {
        return CIN.of(idcard);
    }

    public static boolean isValidHkMoHomeReturn(String idCard) {
        if (StrUtil.isEmpty(idCard)) {
            return false;
        }
        String reg = "^[HhMm](\\d{8}|\\d{10})$";
        return idCard.matches("^[HhMm](\\d{8}|\\d{10})$");
    }

    static {
        TW_FIRST_CODE.put(Character.valueOf('A'), 10);
        TW_FIRST_CODE.put(Character.valueOf('B'), 11);
        TW_FIRST_CODE.put(Character.valueOf('C'), 12);
        TW_FIRST_CODE.put(Character.valueOf('D'), 13);
        TW_FIRST_CODE.put(Character.valueOf('E'), 14);
        TW_FIRST_CODE.put(Character.valueOf('F'), 15);
        TW_FIRST_CODE.put(Character.valueOf('G'), 16);
        TW_FIRST_CODE.put(Character.valueOf('H'), 17);
        TW_FIRST_CODE.put(Character.valueOf('J'), 18);
        TW_FIRST_CODE.put(Character.valueOf('K'), 19);
        TW_FIRST_CODE.put(Character.valueOf('L'), 20);
        TW_FIRST_CODE.put(Character.valueOf('M'), 21);
        TW_FIRST_CODE.put(Character.valueOf('N'), 22);
        TW_FIRST_CODE.put(Character.valueOf('P'), 23);
        TW_FIRST_CODE.put(Character.valueOf('Q'), 24);
        TW_FIRST_CODE.put(Character.valueOf('R'), 25);
        TW_FIRST_CODE.put(Character.valueOf('S'), 26);
        TW_FIRST_CODE.put(Character.valueOf('T'), 27);
        TW_FIRST_CODE.put(Character.valueOf('U'), 28);
        TW_FIRST_CODE.put(Character.valueOf('V'), 29);
        TW_FIRST_CODE.put(Character.valueOf('X'), 30);
        TW_FIRST_CODE.put(Character.valueOf('Y'), 31);
        TW_FIRST_CODE.put(Character.valueOf('W'), 32);
        TW_FIRST_CODE.put(Character.valueOf('Z'), 33);
        TW_FIRST_CODE.put(Character.valueOf('I'), 34);
        TW_FIRST_CODE.put(Character.valueOf('O'), 35);
    }
}

