/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.func;

import cn.ujava.common.exception.ExceptionUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface SerBinaryOperator<T>
extends BinaryOperator<T>,
Serializable {
    public T applying(T var1, T var2) throws Exception;

    @Override
    default public T apply(T t, T u) {
        try {
            return this.applying(t, u);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }

    public static <T> SerBinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> SerBinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }

    public static <T> SerBinaryOperator<T> justBefore() {
        return (l, r) -> l;
    }

    public static <T> SerBinaryOperator<T> justAfter() {
        return (l, r) -> r;
    }
}

