/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io;

import java.io.IOException;
import java.io.Reader;

public class FastStringReader
extends Reader {
    private String str;
    private final int length;
    private int next = 0;
    private int mark = 0;

    public FastStringReader(String s) {
        this.str = s;
        this.length = s.length();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    @Override
    public int read(char[] charBuffer, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > charBuffer.length || len < 0 || off + len > charBuffer.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.str.getChars(this.next, this.next + n, charBuffer, off);
        this.next += n;
        return n;
    }

    @Override
    public long skip(long ns) throws IOException {
        this.ensureOpen();
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        n = Math.max((long)(-this.next), n);
        this.next = (int)((long)this.next + n);
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.ensureOpen();
        this.mark = this.next;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.next = this.mark;
    }

    @Override
    public void close() {
        this.str = null;
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }
}

