/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.file;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.file.PathUtil;
import cn.ujava.common.io.file.visitor.CopyVisitor;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.lang.copier.SrcToDestCopier;
import cn.ujava.common.util.ObjUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class PathCopier
extends SrcToDestCopier<Path, PathCopier> {
    private static final long serialVersionUID = 1L;
    private final CopyOption[] options;

    public static PathCopier of(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return PathCopier.of(src, target, copyOptionArray);
    }

    public static PathCopier of(Path src, Path target, CopyOption[] options) {
        return new PathCopier(src, target, options);
    }

    public PathCopier(Path src, Path target, CopyOption[] options) {
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!PathUtil.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = src;
        this.target = Assert.notNull(target, "Target path must be not null !", new Object[0]);
        this.options = ObjUtil.defaultIfNull(options, new CopyOption[0]);
    }

    @Override
    public Path copy() throws IORuntimeException {
        if (PathUtil.isDirectory((Path)this.src)) {
            if (PathUtil.exists((Path)this.target, false)) {
                if (PathUtil.isDirectory((Path)this.target)) {
                    return PathCopier._copyContent((Path)this.src, ((Path)this.target).resolve(((Path)this.src).getFileName()), this.options);
                }
                throw new IllegalArgumentException("Can not copy directory to a file!");
            }
            return PathCopier._copyContent((Path)this.src, (Path)this.target, this.options);
        }
        return PathCopier.copyFile((Path)this.src, (Path)this.target, this.options);
    }

    public Path copyContent() throws IORuntimeException {
        if (PathUtil.isDirectory((Path)this.src, false)) {
            return PathCopier._copyContent((Path)this.src, (Path)this.target, this.options);
        }
        return PathCopier.copyFile((Path)this.src, (Path)this.target, this.options);
    }

    private static Path _copyContent(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        try {
            Files.walkFileTree(src, new CopyVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return target;
    }

    private static Path copyFile(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(target, "Destination File or directory is null !", new Object[0]);
        Path targetPath = PathUtil.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        PathUtil.mkParentDirs(targetPath);
        try {
            return Files.copy(src, targetPath, options);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

