/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.file;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.file.PathUtil;
import cn.ujava.common.io.file.visitor.DelVisitor;
import cn.ujava.common.lang.Assert;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public class PathDeleter {
    private final Path path;

    public static PathDeleter of(Path src) {
        return new PathDeleter(src);
    }

    public PathDeleter(Path path) {
        this.path = Assert.notNull(path, "Path must be not null !", new Object[0]);
    }

    public void del() throws IORuntimeException {
        Path path = this.path;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        if (PathUtil.isDirectory(path)) {
            PathDeleter._del(path);
        } else {
            PathDeleter.delFile(path);
        }
    }

    public void clean() {
        try (Stream<Path> list = Files.list(this.path);){
            list.forEach(PathUtil::del);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void _del(Path path) {
        try {
            Files.walkFileTree(path, DelVisitor.INSTANCE);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void delFile(Path path) throws IORuntimeException {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            if (e instanceof AccessDeniedException && path.toFile().delete()) {
                return;
            }
            throw new IORuntimeException(e);
        }
    }
}

