/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.resource;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.text.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;

public class BytesResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] bytes;
    private final String name;

    public BytesResource(byte[] bytes) {
        this(bytes, null);
    }

    public BytesResource(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public long size() {
        return this.bytes.length;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        return StrUtil.str(this.bytes, charset);
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        return this.bytes;
    }
}

