/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.resource;

import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.io.resource.NoResourceException;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.net.url.URLUtil;
import cn.ujava.common.util.ObjUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final long lastModified;
    private final String name;

    public FileResource(String path) {
        this(FileUtil.file(path));
    }

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, null);
    }

    public FileResource(File file, String fileName) {
        Assert.notNull(file, "File must be not null !", new Object[0]);
        this.file = file;
        this.lastModified = file.lastModified();
        this.name = ObjUtil.defaultIfNull(fileName, file::getName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return URLUtil.getURL(this.file);
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        return FileUtil.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }
}

