/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.net.ssl;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.lang.builder.Builder;
import cn.ujava.common.net.ssl.SSLProtocols;
import cn.ujava.common.net.ssl.TrustAnyTrustManager;
import cn.ujava.common.text.StrUtil;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextBuilder
implements SSLProtocols,
Builder<SSLContext> {
    private static final long serialVersionUID = 1L;
    private String protocol = "TLS";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers = new TrustManager[]{TrustAnyTrustManager.INSTANCE};
    private SecureRandom secureRandom = new SecureRandom();

    public static SSLContextBuilder of() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder setProtocol(String protocol) {
        if (StrUtil.isNotBlank(protocol)) {
            this.protocol = protocol;
        }
        return this;
    }

    public SSLContextBuilder setTrustManagers(TrustManager ... trustManagers) {
        if (ArrayUtil.isNotEmpty(trustManagers)) {
            this.trustManagers = trustManagers;
        }
        return this;
    }

    public SSLContextBuilder setKeyManagers(KeyManager ... keyManagers) {
        if (ArrayUtil.isNotEmpty(keyManagers)) {
            this.keyManagers = keyManagers;
        }
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        if (null != secureRandom) {
            this.secureRandom = secureRandom;
        }
        return this;
    }

    @Override
    public SSLContext build() {
        return this.buildQuietly();
    }

    public SSLContext buildChecked() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext;
    }

    public SSLContext buildQuietly() throws IORuntimeException {
        try {
            return this.buildChecked();
        }
        catch (GeneralSecurityException e) {
            throw new IORuntimeException(e);
        }
    }
}

