/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.net.ssl;

import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.net.ssl.SSLContextBuilder;
import cn.ujava.common.net.ssl.TrustAnyTrustManager;
import cn.ujava.common.text.StrUtil;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    public static X509TrustManager getTrustManager(KeyStore keyStore, Provider provider) {
        return SSLUtil.getTrustManager(keyStore, null, provider);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManager[] tms;
        TrustManagerFactory tmf;
        if (StrUtil.isEmpty(algorithm)) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        try {
            tmf = null == provider ? TrustManagerFactory.getInstance(algorithm) : TrustManagerFactory.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HutoolException(e);
        }
        try {
            tmf.init(keyStore);
        }
        catch (KeyStoreException e) {
            throw new HutoolException(e);
        }
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    public static SSLContext createTrustAnySSLContext() throws IORuntimeException {
        return SSLUtil.createTrustAnySSLContext(null);
    }

    public static SSLContext createTrustAnySSLContext(String protocol) throws IORuntimeException {
        return SSLContextBuilder.of().setProtocol(protocol).setTrustManagers(TrustAnyTrustManager.INSTANCE).build();
    }

    public static SSLContext createSSLContext(String protocol, KeyManager keyManager, TrustManager trustManager) throws IORuntimeException {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        if (keyManager == null) {
            keyManagerArray = null;
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = keyManager;
        }
        if (trustManager == null) {
            trustManagerArray = null;
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = trustManager;
        }
        return SSLUtil.createSSLContext(protocol, keyManagerArray, trustManagerArray);
    }

    public static SSLContext createSSLContext(String protocol, KeyManager[] keyManagers, TrustManager[] trustManagers) throws IORuntimeException {
        return SSLContextBuilder.of().setProtocol(protocol).setKeyManagers(keyManagers).setTrustManagers(trustManagers).build();
    }
}

