/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.spi;

import cn.ujava.common.cache.SimpleCache;
import cn.ujava.common.classloader.ClassLoaderUtil;
import cn.ujava.common.collection.ListUtil;
import cn.ujava.common.io.resource.ResourceUtil;
import cn.ujava.common.reflect.ConstructorUtil;
import cn.ujava.common.spi.AbsServiceLoader;
import cn.ujava.common.text.StrUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class MapServiceLoader<S>
extends AbsServiceLoader<S> {
    private static final String PREFIX_HUTOOL = "META-INF/hutool/";
    private Properties serviceProperties;
    private final SimpleCache<String, S> serviceCache = new SimpleCache(new HashMap());

    public static <S> MapServiceLoader<S> of(Class<S> serviceClass) {
        return MapServiceLoader.of(serviceClass, null);
    }

    public static <S> MapServiceLoader<S> of(Class<S> serviceClass, ClassLoader classLoader) {
        return MapServiceLoader.of(PREFIX_HUTOOL, serviceClass, classLoader);
    }

    public static <S> MapServiceLoader<S> of(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader) {
        return new MapServiceLoader<S>(pathPrefix, serviceClass, classLoader, null);
    }

    public MapServiceLoader(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader, Charset charset) {
        super(pathPrefix, serviceClass, classLoader, charset);
        this.load();
    }

    @Override
    public void load() {
        Properties properties = new Properties();
        ResourceUtil.loadAllTo(properties, this.pathPrefix + this.serviceClass.getName(), this.classLoader, this.charset, false);
        this.serviceProperties = properties;
    }

    @Override
    public int size() {
        return this.serviceProperties.size();
    }

    @Override
    public List<String> getServiceNames() {
        return ListUtil.view(this.serviceCache.keys());
    }

    @Override
    public Class<S> getServiceClass(String serviceName) {
        String serviceClassName = this.serviceProperties.getProperty(serviceName);
        if (StrUtil.isBlank(serviceClassName)) {
            return null;
        }
        return ClassLoaderUtil.loadClass(serviceClassName);
    }

    @Override
    public S getService(String serviceName) {
        return (S)this.serviceCache.get(serviceName, () -> this.createService(serviceName));
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private final Iterator<String> nameIter;
            {
                this.nameIter = MapServiceLoader.this.serviceProperties.stringPropertyNames().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nameIter.hasNext();
            }

            @Override
            public S next() {
                return MapServiceLoader.this.getService(this.nameIter.next());
            }
        };
    }

    private S createService(String serviceName) {
        return ConstructorUtil.newInstance(this.getServiceClass(serviceName), new Object[0]);
    }
}

