/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.stream;

import cn.ujava.common.stream.EasyStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface WrappedStream<T, S extends WrappedStream<T, S>>
extends Stream<T>,
Iterable<T> {
    public static final int NOT_FOUND_ELEMENT_INDEX = -1;

    public Stream<T> unwrap();

    public S wrap(Stream<T> var1);

    default public S filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.wrap(this.unwrap().filter(predicate));
    }

    @Override
    default public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.unwrap().mapToInt(mapper);
    }

    @Override
    default public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.unwrap().mapToLong(mapper);
    }

    @Override
    default public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.unwrap().mapToDouble(mapper);
    }

    @Override
    default public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.unwrap().flatMapToInt(mapper);
    }

    @Override
    default public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.unwrap().flatMapToLong(mapper);
    }

    @Override
    default public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.unwrap().flatMapToDouble(mapper);
    }

    default public S distinct() {
        return this.wrap(this.unwrap().distinct());
    }

    default public S sorted() {
        return this.wrap(this.unwrap().sorted());
    }

    default public S sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.wrap(this.unwrap().sorted(comparator));
    }

    default public S peek(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        return this.wrap(this.unwrap().peek(action));
    }

    default public S limit(long maxSize) {
        return this.wrap(this.unwrap().limit(maxSize));
    }

    default public S skip(long n) {
        return this.wrap(this.unwrap().skip(n));
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.unwrap().forEach(action);
    }

    @Override
    default public void forEachOrdered(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.unwrap().forEachOrdered(action);
    }

    @Override
    default public Object[] toArray() {
        return this.unwrap().toArray();
    }

    @Override
    default public <A> A[] toArray(IntFunction<A[]> generator) {
        Objects.requireNonNull(generator);
        return this.unwrap().toArray(generator);
    }

    @Override
    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.unwrap().reduce(identity, accumulator);
    }

    @Override
    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.unwrap().reduce(accumulator);
    }

    @Override
    default public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return this.unwrap().reduce(identity, accumulator, combiner);
    }

    @Override
    default public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return this.unwrap().collect(supplier, accumulator, combiner);
    }

    @Override
    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        Objects.requireNonNull(collector);
        return this.unwrap().collect(collector);
    }

    @Override
    default public Optional<T> min(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.unwrap().min(comparator);
    }

    @Override
    default public Optional<T> max(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.unwrap().max(comparator);
    }

    @Override
    default public long count() {
        return this.unwrap().count();
    }

    @Override
    default public boolean anyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.unwrap().anyMatch(predicate);
    }

    @Override
    default public boolean allMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.unwrap().allMatch(predicate);
    }

    @Override
    default public boolean noneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.unwrap().noneMatch(predicate);
    }

    @Override
    default public Optional<T> findFirst() {
        return this.unwrap().findFirst();
    }

    @Override
    default public Optional<T> findAny() {
        return this.unwrap().findAny();
    }

    @Override
    default public Iterator<T> iterator() {
        return this.unwrap().iterator();
    }

    @Override
    default public Spliterator<T> spliterator() {
        return this.unwrap().spliterator();
    }

    @Override
    default public boolean isParallel() {
        return this.unwrap().isParallel();
    }

    @Override
    default public S sequential() {
        return this.wrap((Stream)this.unwrap().sequential());
    }

    @Override
    default public S parallel() {
        return this.wrap((Stream)this.unwrap().parallel());
    }

    @Override
    default public S unordered() {
        return this.wrap((Stream)this.unwrap().unordered());
    }

    @Override
    default public S onClose(Runnable closeHandler) {
        return this.wrap((Stream)this.unwrap().onClose(closeHandler));
    }

    @Override
    default public void close() {
        this.unwrap().close();
    }

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();

    default public EasyStream<T> easyStream() {
        if (this instanceof EasyStream) {
            return (EasyStream)this;
        }
        if (this instanceof Iterator) {
            return EasyStream.of((Iterator)((Object)this));
        }
        return EasyStream.of(this.collect(Collectors.toList()));
    }
}

