/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.tree.hierarchy;

import cn.ujava.common.lang.mutable.Mutable;
import cn.ujava.common.lang.mutable.MutableObj;
import cn.ujava.common.tree.hierarchy.HierarchyIterator;
import cn.ujava.common.tree.hierarchy.HierarchyIteratorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class HierarchyIteratorUtil {
    public static <H, R> HierarchyIterator<H, R> find(Function<H, Collection<H>> function, Function<H, R> finder) {
        Objects.requireNonNull(function);
        Objects.requireNonNull(finder);
        MutableObj<Object> mutable = Mutable.of(null);
        Predicate<Object> terminator = h -> {
            Object r = finder.apply(h);
            if (r != null) {
                mutable.set(r);
                return true;
            }
            return false;
        };
        return new HierarchyIteratorImpl<Object, Object>(mutable::get, terminator, (r, h) -> (Collection)function.apply(h));
    }

    public static <H> HierarchyIterator<H, Void> scan(Function<H, Collection<H>> function, Predicate<H> terminator) {
        Objects.requireNonNull(function);
        return new HierarchyIteratorImpl<Object, Void>(() -> null, terminator, (r, h) -> (Collection)function.apply(h));
    }

    public static <H> HierarchyIterator<H, Void> scan(Function<H, Collection<H>> function) {
        return HierarchyIteratorUtil.scan(function, h -> false);
    }

    public static <H, R, C extends Collection<R>> HierarchyIterator<H, C> collect(Function<H, Collection<H>> function, Supplier<C> collFactory, Function<H, R> mapper) {
        Objects.requireNonNull(function);
        Objects.requireNonNull(collFactory);
        Objects.requireNonNull(mapper);
        Collection collection = (Collection)collFactory.get();
        return new HierarchyIteratorImpl<Object, Collection>(() -> collection, h -> false, (r, h) -> {
            Object apply = mapper.apply(h);
            if (Objects.nonNull(apply)) {
                collection.add(apply);
            }
            return (Collection)function.apply(h);
        });
    }

    public static <H, R> HierarchyIterator<H, List<R>> collect(Function<H, Collection<H>> function, Function<H, R> mapper) {
        return HierarchyIteratorUtil.collect(function, ArrayList::new, mapper);
    }

    public static <H> HierarchyIterator<H, List<H>> collect(Function<H, Collection<H>> function) {
        return HierarchyIteratorUtil.collect(function, Function.identity());
    }
}

