/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.cookie;

import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.cookie.CommonCookieAttributeHandler;
import co.datadome.api.shaded.http.cookie.Cookie;
import co.datadome.api.shaded.http.cookie.CookieOrigin;
import co.datadome.api.shaded.http.cookie.MalformedCookieException;
import co.datadome.api.shaded.http.cookie.SetCookie;
import co.datadome.api.shaded.http.impl.cookie.AbstractCookieAttributeHandler;
import co.datadome.api.shaded.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

