/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.common;

import co.datadome.api.shaded.http.conn.DnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;

public class DataDomeResolver
implements DnsResolver {
    private final String host;
    private final int refreshIn;
    private final DnsResolver dnsResolver;
    private InetAddress[] inetAddresses;
    private AtomicLong lastTimeRefreshed = new AtomicLong(Long.MIN_VALUE);

    public DataDomeResolver(String host, int refreshIn, DnsResolver dnsResolver) throws UnknownHostException {
        this.host = host;
        this.refreshIn = refreshIn;
        this.dnsResolver = dnsResolver;
        this.refresh();
    }

    public InetAddress[] refresh() throws UnknownHostException {
        InetAddress[] resolved = this.dnsResolver.resolve(this.host);
        this.inetAddresses = resolved;
        return resolved;
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        if (!this.host.equals(host)) {
            throw new UnknownHostException("DataDome resolver configured to resolve only " + this.host);
        }
        long lastTime = this.lastTimeRefreshed.get();
        long now = System.currentTimeMillis();
        if (this.refreshIn <= 0 || now - (long)this.refreshIn > lastTime && this.lastTimeRefreshed.compareAndSet(lastTime, now)) {
            this.refresh();
        }
        return this.inetAddresses;
    }
}

