/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.common;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataDomeResponse {
    private static final Logger logger = Logger.getLogger(DataDomeResponse.class.getCanonicalName());
    private final int statusCode;
    private final String responseBody;
    private final Map<String, String> requestHeaders;
    private final Map<String, String> responseHeaders;

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    DataDomeResponse(int statusCode, String responseBody, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        this.statusCode = statusCode;
        this.responseBody = responseBody;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
    }

    public boolean shouldBeBlocked() {
        return DataDomeResponse.shouldBeBlocked(this.getStatusCode());
    }

    public static boolean shouldBeBlocked(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 401: 
            case 403: {
                return true;
            }
            case 200: {
                return false;
            }
        }
        logger.log(Level.WARNING, "Unexpected status from DataDome API server: {0}", statusCode);
        return false;
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int statusCode;
        private String responseBody;
        private Map<String, String> requestHeaders;
        private Map<String, String> responseHeaders;

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setResponseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public Builder setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        public Builder setResponseHeaders(Map<String, String> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public DataDomeResponse build() {
            return new DataDomeResponse(this.statusCode, this.responseBody, this.requestHeaders, this.responseHeaders);
        }
    }
}

