/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.entity;

import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpMessage;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.entity.ContentLengthStrategy;
import co.datadome.api.shaded.http.impl.io.ChunkedOutputStream;
import co.datadome.api.shaded.http.impl.io.ContentLengthOutputStream;
import co.datadome.api.shaded.http.impl.io.IdentityOutputStream;
import co.datadome.api.shaded.http.io.SessionOutputBuffer;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        Args.notNull(outbuffer, "Session output buffer");
        Args.notNull(message, "HTTP message");
        Args.notNull(entity, "HTTP entity");
        OutputStream outStream = this.doSerialize(outbuffer, message);
        entity.writeTo(outStream);
        outStream.close();
    }
}

