/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.protocol;

import co.datadome.api.shaded.http.Header;
import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpResponse;
import co.datadome.api.shaded.http.HttpResponseInterceptor;
import co.datadome.api.shaded.http.HttpVersion;
import co.datadome.api.shaded.http.ProtocolVersion;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.protocol.HttpCoreContext;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequest request;
        Args.notNull(response, "HTTP response");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = corecontext.getRequest()) != null) {
            Header header = request.getFirstHeader("Connection");
            if (header != null) {
                response.setHeader("Connection", header.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "Close");
            }
        }
    }
}

