package co.datadome.api.common;

import org.apache.http.conn.DnsResolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;

public class DataDomeResolver implements DnsResolver {

    private final String host;

    private final int refreshIn;

    private final DnsResolver dnsResolver;

    private InetAddress[] inetAddresses;

    private AtomicLong lastTimeRefreshed = new AtomicLong(Long.MIN_VALUE);

    public DataDomeResolver(String host, int refreshIn, DnsResolver dnsResolver) throws UnknownHostException {
        this.host = host;
        this.refreshIn = refreshIn;
        this.dnsResolver = dnsResolver;
        refresh();
    }

    public InetAddress[] refresh() throws UnknownHostException {
        InetAddress[] resolved = dnsResolver.resolve(host);
        this.inetAddresses = resolved;
        return resolved;
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        if (!(this.host.equals(host))) {
            throw new UnknownHostException("DataDome resolver configured to resolve only " + this.host);
        }
        long lastTime = lastTimeRefreshed.get();
        long now = System.currentTimeMillis();
        if (refreshIn <= 0 || (now - refreshIn > lastTime && lastTimeRefreshed.compareAndSet(lastTime, now))) {
            refresh();
        }
        return inetAddresses;
    }
}
