/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.common;

import co.datadome.api.common.DataDomeHeaders;
import co.datadome.api.common.DataDomeRequest;
import co.datadome.api.common.DataDomeResponse;
import co.datadome.api.common.DataDomeService;
import co.datadome.api.common.HttpRequest;
import co.datadome.api.common.IpAddressMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;

public class DataDomeRequestConsumer {
    private static final Logger logger = Logger.getLogger(DataDomeRequestConsumer.class.getSimpleName());
    private final DataDomeService dataDomeService;
    private final Pattern regex;
    private final Pattern exclusionRegex;
    private final List<IpAddressMatcher> subnetMatchers;

    public Pattern getRegex() {
        return this.regex;
    }

    public Pattern getExclusionRegex() {
        return this.exclusionRegex;
    }

    public DataDomeRequestConsumer(DataDomeService dataDomeService, String regex, String exclusionRegex, Collection<String> skipIps) {
        this.dataDomeService = dataDomeService;
        this.subnetMatchers = DataDomeRequestConsumer.convertToSubnet(skipIps);
        this.regex = DataDomeRequestConsumer.nullOrEmpty(regex) ? null : Pattern.compile(regex);
        this.exclusionRegex = DataDomeRequestConsumer.nullOrEmpty(exclusionRegex) ? null : Pattern.compile(exclusionRegex);
    }

    protected static List<IpAddressMatcher> convertToSubnet(Collection<String> subnets) {
        ArrayList<IpAddressMatcher> addressMatchers = new ArrayList<IpAddressMatcher>();
        for (String subnet : subnets) {
            addressMatchers.add(new IpAddressMatcher(subnet));
        }
        return addressMatchers;
    }

    protected static boolean matchSubnets(String ip, List<IpAddressMatcher> subnetMatchers) {
        for (IpAddressMatcher matcher : subnetMatchers) {
            if (!matcher.matches(ip)) continue;
            return true;
        }
        return false;
    }

    private static boolean nullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public void accept(HttpRequest httpRequest) throws IOException, ServletException {
        DataDomeRequest dataDomeRequest = this.buildDataDomeRequest(httpRequest);
        if (!this.isRegexMatched(dataDomeRequest.getUri())) {
            logger.log(Level.FINE, "DataDome regex miss");
            httpRequest.next();
            return;
        }
        if (DataDomeRequestConsumer.matchSubnets(httpRequest.getIp(), this.subnetMatchers)) {
            logger.log(Level.FINE, "DataDome skip IP: {0}", httpRequest.getIp().replaceAll("[\n\r\t]", "_"));
            httpRequest.next();
            return;
        }
        DataDomeResponse dataDomeResponse = this.validateRequest(dataDomeRequest, httpRequest);
        if (dataDomeResponse == null) {
            httpRequest.next();
            return;
        }
        httpRequest.addHeadersInRequest(dataDomeResponse.getRequestHeaders().entrySet());
        httpRequest.addHeadersInResponse(dataDomeResponse.getResponseHeaders().entrySet());
        if (dataDomeResponse.shouldBeBlocked()) {
            httpRequest.block(dataDomeResponse);
            return;
        }
        httpRequest.next();
    }

    protected boolean isRegexMatched(String uri) {
        if (uri == null) {
            return false;
        }
        if (this.exclusionRegex != null && this.exclusionRegex.matcher(uri).find()) {
            return false;
        }
        if (this.regex != null) {
            return this.regex.matcher(uri).find();
        }
        return true;
    }

    private DataDomeResponse validateRequest(DataDomeRequest dataDomeRequest, HttpRequest httpRequest) throws IOException {
        long startTime = System.currentTimeMillis();
        DataDomeResponse dataDomeResponse = this.dataDomeService.validateRequest(dataDomeRequest);
        long elapsedTime = System.currentTimeMillis() - startTime;
        logger.log(Level.INFO, "DataDome request/response time in milliseconds: {0}", elapsedTime);
        httpRequest.timeSpent(elapsedTime);
        return dataDomeResponse;
    }

    public DataDomeRequest buildDataDomeRequest(HttpRequest request) {
        DataDomeRequest.Builder requestBuilder = this.getRequestBuilder();
        requestBuilder.setUserAgent(request.getHeader("User-Agent"));
        requestBuilder.setIp(request.getIp());
        requestBuilder.setPort(request.getPort());
        requestBuilder.setHost(request.getHeader("Host"));
        requestBuilder.setReferer(request.getHeader("Referer"));
        String clientID = request.getHeader("X-DataDome-ClientID");
        boolean shouldUseXSetCookie = clientID != null && clientID.length() > 0;
        requestBuilder.setClientID(shouldUseXSetCookie ? clientID : request.getCookie("datadome"));
        requestBuilder.setxSetCookie(shouldUseXSetCookie);
        requestBuilder.setUri(request.uri());
        requestBuilder.setRequest(DataDomeHeaders.uriQuery(request.uri(), request.query()));
        requestBuilder.setProtocol(request.protocol());
        requestBuilder.setMethod(request.method());
        requestBuilder.setCookiesLen(Integer.toString(DataDomeRequestConsumer.getHeaderLen(request, "Cookie")));
        requestBuilder.setTimeRequest(Long.toString(this.getRequestTimeStampInMicro()));
        requestBuilder.setServerHostname(request.getHeader("Host"));
        requestBuilder.setPostParamLen(request.getHeader("Content-Length"));
        requestBuilder.setForwardedForIP(request.getHeader("X-Forwarded-For"));
        requestBuilder.setHeadersList(DataDomeHeaders.headerList(request.headers()));
        requestBuilder.setAuthorizationLen(Integer.toString(DataDomeRequestConsumer.getHeaderLen(request, "Authorization")));
        requestBuilder.setxRequestedWith(request.getHeader("X-Requested-With"));
        requestBuilder.setOrigin(request.getHeader("Origin"));
        requestBuilder.setConnection(request.getHeader("Connection"));
        requestBuilder.setPragma(request.getHeader("Pragma"));
        requestBuilder.setCacheControl(request.getHeader("Cache-Control"));
        requestBuilder.setContentType(request.getHeader("Content-Type"));
        requestBuilder.setFrom(request.getHeader("From"));
        requestBuilder.setxRealIP(request.getHeader("X-Real-IP"));
        requestBuilder.setVia(request.getHeader("Via"));
        requestBuilder.setTrueClientIP(request.getHeader("True-Client-IP"));
        requestBuilder.setAccept(request.getHeader("Accept"));
        requestBuilder.setAcceptCharset(request.getHeader("Accept-Charset"));
        requestBuilder.setAcceptEncoding(request.getHeader("Accept-Encoding"));
        requestBuilder.setAcceptLanguage(request.getHeader("Accept-Language"));
        requestBuilder.setSecCHUA(request.getHeader("Sec-CH-UA"));
        requestBuilder.setSecCHUAArch(request.getHeader("Sec-CH-UA-Arch"));
        requestBuilder.setSecCHUAFullVersionList(request.getHeader("Sec-CH-UA-Full-Version-List"));
        requestBuilder.setSecCHUAPlatform(request.getHeader("Sec-CH-UA-Platform"));
        requestBuilder.setSecCHUAModel(request.getHeader("Sec-CH-UA-Model"));
        requestBuilder.setSecCHUAMobile(request.getHeader("Sec-CH-UA-Mobile"));
        requestBuilder.setSecCHDeviceMemory(request.getHeader("Sec-CH-Device-Memory"));
        return requestBuilder.build();
    }

    private static int getHeaderLen(HttpRequest request, String name) {
        String value = request.getHeader(name);
        return value == null ? 0 : value.length();
    }

    public DataDomeRequest.Builder getRequestBuilder() {
        return DataDomeRequest.builder();
    }

    public long getRequestTimeStampInMicro() {
        return System.currentTimeMillis() * 1000L;
    }

    public List<IpAddressMatcher> getSubnetMatchers() {
        return this.subnetMatchers;
    }
}

