/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.vertx;

import co.datadome.api.common.DataDomeResponse;
import co.datadome.api.common.HttpRequest;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class RoutingContextRequest
implements HttpRequest {
    private final RoutingContext routingContext;

    public RoutingContextRequest(RoutingContext routingContext) {
        this.routingContext = routingContext;
    }

    @Override
    public String getCookie(String name) {
        Cookie cookie = this.routingContext.getCookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public String uri() {
        return this.routingContext.request().uri();
    }

    @Override
    public String query() {
        return this.routingContext.request().query();
    }

    @Override
    public String protocol() {
        return this.routingContext.request().scheme();
    }

    @Override
    public String method() {
        return this.routingContext.request().method().name();
    }

    @Override
    public void next() {
        this.routingContext.next();
    }

    @Override
    public void timeSpent(long elapsedTime) {
        this.routingContext.request().formAttributes().add("datadome.spent_time", Long.toString(elapsedTime));
    }

    @Override
    public void addHeadersInRequest(Set<Map.Entry<String, String>> headers) {
        HttpServerRequest request = this.routingContext.request();
        for (Map.Entry<String, String> header : headers) {
            request.headers().add(header.getKey(), header.getValue());
        }
    }

    @Override
    public void addHeadersInResponse(Set<Map.Entry<String, String>> headers) {
        HttpServerResponse response = this.routingContext.response();
        for (Map.Entry<String, String> header : headers) {
            response.headers().add(header.getKey(), header.getValue());
        }
    }

    @Override
    public void block(DataDomeResponse dataDomeResponse) {
        HttpServerResponse response = this.routingContext.response();
        response.setStatusCode(dataDomeResponse.getStatusCode());
        response.putHeader("Content-Type", "text/html");
        response.end(dataDomeResponse.getResponseBody());
    }

    @Override
    public String getHeader(String header) {
        return this.routingContext.request().getHeader(header);
    }

    @Override
    public Collection<String> headers() {
        return this.routingContext.request().headers().names();
    }

    @Override
    public String getIp() {
        return this.routingContext.request().remoteAddress().host();
    }

    @Override
    public String getPort() {
        return Integer.toString(this.routingContext.request().remoteAddress().port());
    }
}

