package co.datadome.api.common;

/**
 * Contains details about the DataDomeRequest request
 *
 * <p>
 * Example:
 * <pre>
 * {@code
 * DataDomeRequest.builder builder = DataDomeRequest.builder();
 * builder.setIp("127.0.0.1");
 * builder.setMethod("GET");
 * builder.setProtocol("HTTPS");
 * ...
 * DataDomeRequest dataDomeRequest = builder.build();
 * }
 * </pre>
 *
 */
@java.lang.SuppressWarnings("squid:S00107")
public class DataDomeRequest {

	private final String userAgent;

	private final String ip;

	private final String port;

	private final String clientID;

	private final String host;

	private final String referer;

	private final String request;

	private final String uri;

	private final String protocol;

	private final String method;

	private final String cookiesLen;

	private final String timeRequest;

	private final String serverHostname;

	private final String postParamLen;

	private final String xForwardedForIP;

	private final String headersList;

	private final String authorizationLen;

	private final String xRequestedWith;

	private final String origin;

	private final String connection;

	private final String pragma;

	private final String cacheControl;

	private final String accept;

	private final String acceptCharset;

	private final String acceptEncoding;

	private final String acceptLanguage;

	private final String contentType;

	private final String from;

	private final String xRealIP;

	private final String via;

	private final String trueClientIP;

	private final boolean xSetCookie;

	private final String secCHUA;

	private final String secCHUAArch;

	private final String secCHUAFullVersionList;

	private final String secCHUAPlatform;

	private final String secCHUAModel;

	private final String secCHUAMobile;

	private final String secCHDeviceMemory;

	

	private DataDomeRequest(String userAgent, String ip, String port, String clientID, String host, String referer, String request, String uri, String protocol, String method, String cookiesLen, String timeRequest, String serverHostname, String postParamLen, String xForwardedForIP, String headersList, String authorizationLen, String xRequestedWith, String origin, String connection, String pragma, String cacheControl, String accept, String acceptCharset, String acceptEncoding, String acceptLanguage, String contentType, String from, String xRealIP, String via, String trueClientIP, boolean xSetCookie, String secCHUA, String secCHUAArch, String secCHUAFullVersionList, String secCHUAPlatform, String secCHUAModel, String secCHUAMobile, String secCHDeviceMemory) {
		this.userAgent = userAgent;
		this.ip = ip;
		this.port = port;
		this.clientID = clientID;
		this.host = host;
		this.referer = referer;
		this.request = request;
		this.uri = uri;
		this.protocol = protocol;
		this.method = method;
		this.cookiesLen = cookiesLen;
		this.timeRequest = timeRequest;
		this.serverHostname = serverHostname;
		this.postParamLen = postParamLen;
		this.xForwardedForIP = xForwardedForIP;
		this.headersList = headersList;
		this.authorizationLen = authorizationLen;
		this.xRequestedWith = xRequestedWith;
		this.origin = origin;
		this.connection = connection;
		this.pragma = pragma;
		this.cacheControl = cacheControl;
		this.accept = accept;
		this.acceptCharset = acceptCharset;
		this.acceptEncoding = acceptEncoding;
		this.acceptLanguage = acceptLanguage;
		this.contentType = contentType;
		this.from = from;
		this.xRealIP = xRealIP;
		this.via = via;
		this.trueClientIP = trueClientIP;
		this.xSetCookie = xSetCookie;
		this.secCHUA = secCHUA;
		this.secCHUAArch = secCHUAArch;
		this.secCHUAFullVersionList = secCHUAFullVersionList;
		this.secCHUAPlatform = secCHUAPlatform;
		this.secCHUAModel = secCHUAModel;
		this.secCHUAMobile =  secCHUAMobile;
		this.secCHDeviceMemory = secCHDeviceMemory;

	}

	public String getUserAgent() {
		return userAgent;
	}

	public String getIp() {
		return ip;
	}

	public String getPort() {
		return port;
	}

	public String getClientID() {
		return clientID;
	}

	public String getHost() {
		return host;
	}

	public String getReferer() {
		return referer;
	}

	public String getRequest() {
		return request;
	}

	public String getUri() {
		return uri;
	}

	public String getProtocol() {
		return protocol;
	}

	public String getMethod() {
		return method;
	}

	public String getCookiesLen() {
		return cookiesLen;
	}

	public String getTimeRequest() {
		return timeRequest;
	}

	public String getServerHostname() {
		return serverHostname;
	}

	public String getPostParamLen() {
		return postParamLen;
	}

	public String getxForwardedForIP() {
		return xForwardedForIP;
	}

	public String getHeadersList() {
		return headersList;
	}

	public String getAuthorizationLen() {
		return authorizationLen;
	}

	public String getxRequestedWith() {
		return xRequestedWith;
	}

	public String getOrigin() {
		return origin;
	}

	public String getConnection() {
		return connection;
	}

	public String getPragma() {
		return pragma;
	}

	public String getCacheControl() {
		return cacheControl;
	}

	public String getAccept() {
		return accept;
	}

	public String getAcceptCharset() {
		return acceptCharset;
	}

	public String getAcceptEncoding() {
		return acceptEncoding;
	}

	public String getAcceptLanguage() {
		return acceptLanguage;
	}

	public String getContentType() {
		return contentType;
	}

	public String getFrom() {
		return from;
	}

	public String getxRealIP() {
		return xRealIP;
	}

	public String getVia() {
		return via;
	}

	public String getTrueClientIP() {
		return trueClientIP;
	}

	public boolean getxSetCookie() {
		return xSetCookie;
	}

	public String getSecCHUA() {
		return this.secCHUA;
	}

	public String getSecCHUAArch() {
		return this.secCHUAArch;
	}

	public String getSecCHUAFullVersionList() {
		return this.secCHUAFullVersionList;
	}

	public String getSecCHUAPlatform() {
		return this.secCHUAPlatform;
	}

	public String getSecCHUAMobile() {
		return this.secCHUAMobile;
	}

	public String getSecCHUAModel() {
		return this.secCHUAModel;
	}

	public String getSecCHDeviceMemory() {
		return this.secCHDeviceMemory;
	}

	public static Builder builder() {
		return new Builder();
	}

	public static class Builder {
		private String userAgent;
		private String ip;
		private String port;
		private String clientID;
		private String host;
		private String referer;
		private String request;
		private String uri;
		private String protocol;
		private String method;
		private String cookiesLen;
		private String timeRequest;
		private String serverHostname;
		private String postParamLen;
		private String xForwardedForIP;
		private String headersList;
		private String authorizationLen;
		private String xRequestedWith;
		private String origin;
		private String connection;
		private String pragma;
		private String cacheControl;
		private String accept;
		private String acceptCharset;
		private String acceptEncoding;
		private String acceptLanguage;
		private String contentType;
		private String from;
		private String xRealIP;
		private String via;
		private String trueClientIP;
		private boolean xSetCookie;
		private String secCHUA;
		private String secCHUAArch;
		private String secCHUAFullVersionList;
		private String secCHUAPlatform;
		private String secCHUAModel;
		private String secCHUAMobile;
		private String secCHDeviceMemory;

		public Builder setUserAgent(String userAgent) {
			this.userAgent = userAgent;
			return this;
		}

		public Builder setIp(String ip) {
			this.ip = ip;
			return this;
		}

		public Builder setPort(String port) {
			this.port = port;
			return this;
		}

		public Builder setClientID(String clientID) {
			this.clientID = clientID;
			return this;
		}

		public Builder setHost(String host) {
			this.host = host;
			return this;
		}

		public Builder setReferer(String referer) {
			this.referer = referer;
			return this;
		}

		public Builder setRequest(String request) {
			this.request = request;
			return this;
		}

		public Builder setUri(String uri) {
			this.uri = uri;
			return this;
		}

		public Builder setProtocol(String protocol) {
			this.protocol = protocol;
			return this;
		}

		public Builder setMethod(String method) {
			this.method = method;
			return this;
		}

		public Builder setCookiesLen(String cookiesLen) {
			this.cookiesLen = cookiesLen;
			return this;
		}

		public Builder setTimeRequest(String timeRequest) {
			this.timeRequest = timeRequest;
			return this;
		}

		public Builder setServerHostname(String serverHostname) {
			this.serverHostname = serverHostname;
			return this;
		}

		public Builder setPostParamLen(String postParamLen) {
			this.postParamLen = postParamLen;
			return this;
		}

		public Builder setForwardedForIP(String xForwardedForIP) {
			this.xForwardedForIP = xForwardedForIP;
			return this;
		}

		public Builder setHeadersList(String headersList) {
			this.headersList = headersList;
			return this;
		}

		public Builder setAuthorizationLen(String authorizationLen) {
			this.authorizationLen = authorizationLen;
			return this;
		}

		public Builder setxRequestedWith(String xRequestedWith) {
			this.xRequestedWith = xRequestedWith;
			return this;
		}

		public Builder setOrigin(String origin) {
			this.origin = origin;
			return this;
		}

		public Builder setConnection(String connection) {
			this.connection = connection;
			return this;
		}

		public Builder setPragma(String pragma) {
			this.pragma = pragma;
			return this;
		}

		public Builder setCacheControl(String cacheControl) {
			this.cacheControl = cacheControl;
			return this;
		}

		public Builder setAccept(String accept) {
			this.accept = accept;
			return this;
		}

		public Builder setAcceptCharset(String acceptCharset) {
			this.acceptCharset = acceptCharset;
			return this;
		}

		public Builder setAcceptEncoding(String acceptEncoding) {
			this.acceptEncoding = acceptEncoding;
			return this;
		}

		public Builder setAcceptLanguage(String acceptLanguage) {
			this.acceptLanguage = acceptLanguage;
			return this;
		}

		public Builder setContentType(String contentType) {
			this.contentType = contentType;
			return this;
		}

		public Builder setFrom(String from) {
			this.from = from;
			return this;
		}

		public Builder setxRealIP(String xRealIP) {
			this.xRealIP = xRealIP;
			return this;
		}

		public Builder setVia(String via) {
			this.via = via;
			return this;
		}

		public Builder setTrueClientIP(String trueClientIP) {
			this.trueClientIP = trueClientIP;
			return this;
		}

		public Builder setxSetCookie(boolean xSetCookie) {
			this.xSetCookie = xSetCookie;
			return this;
		}

		public Builder setSecCHUA(String secCHUA) {
			this.secCHUA = secCHUA;
			return this;
		}
	
		public Builder setSecCHUAArch(String secCHUAArch) {
			this.secCHUAArch = secCHUAArch;
			return this;
		}
	
		public Builder setSecCHUAFullVersionList(String secCHUAFullVersionList) {
			this.secCHUAFullVersionList = secCHUAFullVersionList;
			return this;
		}
	
		public Builder setSecCHUAPlatform(String secCHUAPlatform) {
			this.secCHUAPlatform = secCHUAPlatform;
			return this;
		}
	
		public Builder setSecCHUAModel(String secCHUAModel) {
			this.secCHUAModel = secCHUAModel;
			return this;
		}
	
		public Builder setSecCHUAMobile(String secCHUAMobile) {
			this.secCHUAMobile = secCHUAMobile;
			return this;
		}
	
		public Builder setSecCHDeviceMemory(String secCHDeviceMemory) {
			this.secCHDeviceMemory = secCHDeviceMemory;
			return this;
		}

		public DataDomeRequest build() {
			return new DataDomeRequest(userAgent, ip, port, clientID, host, referer, request, uri, protocol, method, cookiesLen, timeRequest, serverHostname, postParamLen, xForwardedForIP, headersList, authorizationLen, xRequestedWith, origin, connection, pragma, cacheControl, accept, acceptCharset, acceptEncoding, acceptLanguage, contentType, from, xRealIP, via, trueClientIP, xSetCookie, secCHUA, secCHUAArch, secCHUAFullVersionList, secCHUAPlatform, secCHUAModel, secCHUAMobile, secCHDeviceMemory);
		}
	}
}
