/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.client;

import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpResponse;
import co.datadome.api.shaded.http.StatusLine;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.client.HttpResponseException;
import co.datadome.api.shaded.http.client.ResponseHandler;
import co.datadome.api.shaded.http.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

