package co.datadome.api.vertx;

import co.datadome.api.common.DataDomeService;

import java.util.Collections;
import java.util.Set;

@java.lang.SuppressWarnings("squid:S00107")
public class DataDomeRouteHandlerConfig {
    private final String apiKey;
    private final String apiHost;
    private final boolean apiSSL;
    private final String regex;
    private final String exclusionRegex;

    private final int connectTimeout;
    private final int readTimeout;
    private final int maxConnections;
    private final String proxyServer;
    private final int proxyPort;
    private final boolean proxySSL;
    private final boolean useXForwardedHost;
    private final Set<String> skipIps;

    private DataDomeRouteHandlerConfig(String apiKey, String apiHost, boolean apiSSL, String regex,
                                       String exclusionRegex, int connectTimeout, int readTimeout,
                                       int maxConnections, String proxyServer, int proxyPort,
                                       boolean proxySSL, Set<String> skipIps, boolean useXForwardedHost) {
        this.apiKey = apiKey;
        this.apiHost = apiHost;
        this.apiSSL = apiSSL;
        this.regex = regex;
        this.exclusionRegex = exclusionRegex;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxConnections = maxConnections;
        this.proxyServer = proxyServer;
        this.proxyPort = proxyPort;
        this.proxySSL = proxySSL;
        this.skipIps = skipIps;
        this.useXForwardedHost = useXForwardedHost;
    }

    public String getApiKey() {
        return apiKey;
    }

    public String getApiHost() {
        return apiHost;
    }

    public boolean isApiSSL() {
        return apiSSL;
    }

    public String getRegex() {
        return regex;
    }

    public String getExclusionRegex() {
        return exclusionRegex;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public String getProxyServer() {
        return proxyServer;
    }

    public int getProxyPort() {
        return proxyPort;
    }

    public boolean isProxySSL() {
        return proxySSL;
    }
    public boolean isForwardedHost() {
        return useXForwardedHost;
    }

    public Set<String> getSkipIps() {
        return skipIps;
    }


    public static class DataDomeRouteHandlerConfigBuilder {
        private final String apiKey;
        private String apiHost = DataDomeService.DEFAULT_API_HOST;
        private boolean apiSSL = DataDomeService.DEFAULT_API_SSL;
        private String regex = DataDomeService.DEFAULT_REGEX;
        private String exclusionRegex = DataDomeService.DEFAULT_EXCLUSION_REGEX;

        private int connectTimeout = DataDomeService.DEFAULT_CONNECT_TIMEOUT;
        private int readTimeout = DataDomeService.DEFAULT_READ_TIMEOUT;
        private int maxConnections = DataDomeService.DEFAULT_MAX_TOTAL_CONNECTIONS;

        private String proxyServer = "";
        private int proxyPort = 0;
        private boolean proxySSL = false;
        private boolean useXForwardedHost = false;

        private Set<String> skipIps = Collections.emptySet();

        public DataDomeRouteHandlerConfigBuilder(final String apiKey) {
            this.apiKey = apiKey;
        }

        public DataDomeRouteHandlerConfigBuilder apiHost(final String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder apiSSL(final boolean apiSSL) {
            this.apiSSL = apiSSL;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder regex(final String regex) {
            this.regex = regex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder exclusionRegex(final String exclusionRegex) {
            this.exclusionRegex = exclusionRegex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder connectTimeout(final int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder readTimeout(final int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder maxConnections(final int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxyServer(final String proxyServer) {
            this.proxyServer = proxyServer;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxyPort(final int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxySSL(final boolean proxySSL) {
            this.proxySSL = proxySSL;
            return this;
        }
        public DataDomeRouteHandlerConfigBuilder useXForwardedHost(final boolean useXForwardedHost) {
            this.useXForwardedHost = useXForwardedHost;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder skipIps(final Set<String> skipIps) {
            this.skipIps = skipIps;
            return this;
        }

        public DataDomeRouteHandlerConfig build() {
            return new DataDomeRouteHandlerConfig(apiKey, apiHost, apiSSL, regex, exclusionRegex, connectTimeout,
                    readTimeout, maxConnections, proxyServer, proxyPort, proxySSL, skipIps, useXForwardedHost);
        }
    }
}

