/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.entity;

import co.datadome.api.shaded.http.Header;
import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpMessage;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.entity.BasicHttpEntity;
import co.datadome.api.shaded.http.entity.ContentLengthStrategy;
import co.datadome.api.shaded.http.impl.io.ChunkedInputStream;
import co.datadome.api.shaded.http.impl.io.ContentLengthInputStream;
import co.datadome.api.shaded.http.impl.io.IdentityInputStream;
import co.datadome.api.shaded.http.io.SessionInputBuffer;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inBuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inBuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inBuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inBuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inBuffer, message);
    }
}

