package co.datadome.api.vertx;

import co.datadome.api.common.DataDomeResponse;
import co.datadome.api.common.HttpRequest;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import static co.datadome.api.common.DataDomeHeaders.*;

public class RoutingContextRequest implements HttpRequest {
    private final RoutingContext routingContext;

    public RoutingContextRequest(RoutingContext routingContext) {
        this.routingContext = routingContext;
    }

    @Override
    public String getCookie(String name) {
        Cookie cookie = routingContext.getCookie(name);

        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public String uri() {
        return routingContext.request().uri();
    }

    @Override
    public String query() {
        return routingContext.request().query();
    }

    @Override
    public String protocol() {
        return routingContext.request().scheme();
    }

    @Override
    public String method() {
        return routingContext.request().method().name();
    }


    @Override
    public void next() {
        routingContext.next();
    }

    @Override
    public void timeSpent(long elapsedTime) {
        routingContext.request().formAttributes().add(TIME_SPENT, Long.toString(elapsedTime));

    }

    @Override
    public void addHeadersInRequest(Set<Map.Entry<String, String>> headers) {
        HttpServerRequest request = routingContext.request();
        for (Map.Entry<String, String> header : headers) {
            request.headers().add(header.getKey(), header.getValue());
        }
    }

    @Override
    public void addHeadersInResponse(Set<Map.Entry<String, String>> headers) {
        final HttpServerResponse response = routingContext.response();
        for (Map.Entry<String, String> header : headers) {
            response.headers().add(header.getKey(), header.getValue());
        }
    }

    @Override
    public void block(DataDomeResponse dataDomeResponse) {
        final HttpServerResponse response = routingContext.response();
        response.setStatusCode(dataDomeResponse.getStatusCode());
        response.putHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_VALUE);
        response.end(dataDomeResponse.getResponseBody());
    }

    @Override
    public String getHeader(String header) {
        return routingContext.request().getHeader(header);
    }

    @Override
    public Collection<String> headers() {
        return routingContext.request().headers().names();
    }

    @Override
    public String getIp() {
        return routingContext.request().remoteAddress().host();
    }

    @Override
    public String getPort() {
        return Integer.toString(routingContext.request().remoteAddress().port());
    }
}
